/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class MummyTests {
    @BattleTest
    public static CompletableFuture<TestResult> shouldChangeAttackersAbilityWhenHitWithContactMove(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.COFAGRIGUS).ability(AbilityRegistry.MUMMY).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).ability(AbilityRegistry.SYNCHRONIZE).moves(AttackRegistry.AERIAL_ACE).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (!teamB.asWrapper().getBattleAbility().isAbility(AbilityRegistry.MUMMY)) {
                return TestResult.failure("Mew's ability was not changed to Mummy after hitting Cofagrigus with Aerial Ace (expected Mummy, got " + teamB.asWrapper().getBattleAbility() + ")");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotChangePermanentAbilities(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.COFAGRIGUS).ability(AbilityRegistry.MUMMY).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.AERIAL_ACE).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
            });
            if (teamB.asWrapper().getBattleAbility() == AbilityRegistry.MUMMY.get()) {
                return TestResult.failure("Mimikyu's ability was changed to Mummy after hitting Cofagrigus with Aerial Ace");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotActivateBeforeDamageCalc(BattleTestHelper helper) {
        Pokemon sableye = helper.createDefaultPokemon(PixelmonSpecies.SABLEYE).ability(AbilityRegistry.TOUGH_CLAWS).moves(AttackRegistry.BRUTAL_SWING).build();
        Pokemon golisopod = helper.createDefaultPokemon(PixelmonSpecies.GOLISOPOD).ability(AbilityRegistry.EMERGENCY_EXIT).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamA = helper.createParticipant(2, sableye, golisopod);
        Pokemon cofigrigus = helper.createDefaultPokemon(PixelmonSpecies.COFAGRIGUS).ability(AbilityRegistry.MUMMY).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon hoopa = helper.createDefaultPokemon(PixelmonSpecies.HOOPA).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamB = helper.createParticipant(2, cofigrigus, hoopa);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(sableye, 1);
                teamA.attackSelf(golisopod, 1);
                teamB.attackSelf(cofigrigus, 1);
                teamB.attackSelf(hoopa, 1);
            });
            if (!teamB.asWrapper(hoopa).isFainted()) {
                return TestResult.failure("Hoopa should have fainted after getting hit by Sableye's Brutal Swing");
            }
            return TestResult.success();
        });
    }
}

