/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class MultiscaleTests {
    @BattleTest
    public static CompletableFuture<TestResult> testHalvesDamageWhenAtFullHealth(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DRAGONITE).ability(AbilityRegistry.MULTISCALE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.WICKED_BLOW).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            if (helper.inRange(teamA.asWrapper().getHealthDeficit(), 15, 18)) {
                return TestResult.failure("Dragonite took too much damage from Wicked Blow should be [15, 18] but was " + teamA.asWrapper().getHealthDeficit());
            }
            int damage = teamA.asWrapper().getHealthDeficit();
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            if (helper.inRange(teamA.asWrapper().getMaxHealth() - teamA.asWrapper().getHealth() - damage, 30, 36)) {
                return TestResult.failure("Multi scale should not reduce damage as dragonite was already damaged. Expected [30, 36] but instead got " + teamA.asWrapper().getHealthDeficit());
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DRAGONITE).ability(AbilityRegistry.MULTISCALE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.WICKED_BLOW).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            if (helper.inRange(teamA.asWrapper().getHealthDeficit(), 30, 36)) {
                return TestResult.failure("Dragonite took incorrect damage from Wicked Blow should be [30, 36] but was " + teamA.asWrapper().getHealthDeficit());
            }
            return TestResult.success();
        });
    }
}

