/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class MoxieTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBoostsAttackWhenKOsAPokemon(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KROOKODILE).ability(AbilityRegistry.MOXIE).moves(AttackRegistry.CRUNCH).build());
        Pokemon shedinja = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.SPLASH).build();
        TestParticipant teamB = helper.createParticipant(shedinja, magikarp);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackSelf(1);
                teamB.switchPokemon(shedinja, magikarp);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("Krookodile did not receive an Attack boost after KOing a Pokemon");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotBoostStatWhenKOsLastPokemon(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KROOKODILE).ability(AbilityRegistry.MOXIE).moves(AttackRegistry.CRUNCH).build());
        Pokemon shedinja = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamB = helper.createParticipant(shedinja);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackSelf(1);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Krookodile received an Attack boost after KOing the last Pokemon");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotBoostStatWhenKOsMultipleLastPokemon(BattleTestHelper helper) {
        Pokemon krookodile = helper.createDefaultPokemon(PixelmonSpecies.KROOKODILE).ability(AbilityRegistry.MOXIE).moves(AttackRegistry.EARTHQUAKE).build();
        Pokemon shedA = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamA = helper.createParticipant(krookodile, shedA);
        Pokemon shedB1 = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon shedB2 = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamB = helper.createParticipant(shedB1, shedB2);
        return helper.setupDoubleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(krookodile, 1);
                teamA.attackSelf(shedA, 1);
                teamB.attackSelf(shedB1, 1);
                teamB.attackSelf(shedB2, 1);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Krookodile received an Attack boost after KOing all the last Pokemon");
            }
            return TestResult.success();
        });
    }
}

