/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class MagnetPullTests {
    @BattleTest
    public static CompletableFuture<TestResult> testPreventsSteelSwitches(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MAGNEZONE).ability(AbilityRegistry.MAGNET_PULL).moves(AttackRegistry.SOAK, AttackRegistry.CHARGE).build());
        Pokemon heatran = helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.CURSE).build();
        Pokemon starmie = helper.createDefaultPokemon(PixelmonSpecies.STARMIE).ability(AbilityRegistry.ILLUMINATE).moves(AttackRegistry.REFLECT_TYPE).build();
        TestParticipant teamB = helper.createParticipant(heatran, starmie);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(2);
                teamB.switchPokemon(heatran, starmie);
            });
            if (!teamB.asWrapper((Pokemon)heatran).onBattlefield) {
                return TestResult.failure("Heatran was able to switch out even though it was trapped by Magnet Pull");
            }
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackAuto();
            });
            if (!teamB.asWrapper().type.contains(Element.WATER)) {
                return TestResult.failure("Heatran was not transformed into a Water-type by Soak");
            }
            controller.takeFullTurn(() -> {
                teamA.attackAuto();
                teamB.switchPokemon(heatran, starmie);
            });
            if (!teamB.asWrapper((Pokemon)starmie).onBattlefield) {
                return TestResult.failure("Heatran did not switch out after being transformed into a Water-type by Soak");
            }
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(2);
                teamB.attackAuto();
            });
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(2);
                teamB.switchPokemon(starmie, heatran);
            });
            if (!teamB.asWrapper((Pokemon)starmie).onBattlefield) {
                return TestResult.failure("Starmie switched out even though it was trapped by Magnet Pull");
            }
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackAuto();
            });
            if (!teamB.asWrapper((Pokemon)starmie).onBattlefield) {
                return TestResult.failure("Starmie switched out even though it was trapped by Magnet Pull");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotPreventMoveSwitches(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MAGNEZONE).ability(AbilityRegistry.MAGNET_PULL).moves(AttackRegistry.TOXIC).build());
        Pokemon heatran = helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.BATON_PASS).build();
        Pokemon tentacruel = helper.createDefaultPokemon(PixelmonSpecies.TENTACRUEL).ability(AbilityRegistry.CLEAR_BODY).moves(AttackRegistry.RAPID_SPIN).build();
        TestParticipant teamB = helper.createParticipant(heatran, tentacruel);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackSelf(1);
                teamB.switchPokemon(heatran, tentacruel);
            });
            if (!teamB.asWrapper((Pokemon)tentacruel).onBattlefield) {
                return TestResult.failure("Tentacruel switched out even though it was trapped by Magnet Pull");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotPreventTrapImmuneFromSwitching(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MAGNEZONE).ability(AbilityRegistry.MAGNET_PULL).moves(AttackRegistry.SUBSTITUTE).build());
        Pokemon aegislash = helper.createDefaultPokemon(PixelmonSpecies.AEGISLASH).ability(AbilityRegistry.STANCE_CHANGE).moves(AttackRegistry.SWORDS_DANCE).build();
        Pokemon arcanine = helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.ROAR).build();
        TestParticipant teamB = helper.createParticipant(aegislash, arcanine);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.switchPokemon(aegislash, arcanine);
            });
            if (!teamB.asWrapper((Pokemon)arcanine).onBattlefield) {
                return TestResult.failure("Aegislash's switch was prevented even though it was immune to trapping");
            }
            return TestResult.success();
        });
    }
}

