/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class MagicianTests {
    @BattleTest
    public static CompletableFuture<TestResult> testStealsOpponentsItems(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KLEFKI).ability(AbilityRegistry.MAGICIAN).moves(AttackRegistry.FLASH_CANNON).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).heldItem(PixelmonItems.sea_incense).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackAutoTarget(1);
            teamB.attackAutoTarget(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getHeldItem() != PixelmonItems.sea_incense) {
                return TestResult.failure("Magician did not steal Wynaut's held item");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotStealWeaknessPolicyOnSuperEffectiveHits(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KLEFKI).ability(AbilityRegistry.MAGICIAN).moves(AttackRegistry.FLASH_CANNON).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HATTERENE).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackAutoTarget(1);
            teamB.attackAutoTarget(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getHeldItem() == PixelmonItems.weakness_policy) {
                return TestResult.failure("Magician stole Hatterene's Weakness Policy");
            }
            return TestResult.success();
        });
    }
}

