/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class MagicGuardTests {
    @BattleTest
    public static CompletableFuture<TestResult> testPreventsNonAttackDamage(BattleTestHelper helper) {
        Pokemon clefable = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).heldItem(PixelmonItems.life_orb).ability(AbilityRegistry.MAGIC_GUARD).moves(AttackRegistry.DOUBLE_EDGE, AttackRegistry.MIND_BLOWN, AttackRegistry.HIGH_JUMP_KICK).build();
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build();
        TestParticipant teamA = helper.createParticipant(magikarp, clefable);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CROBAT).ability(AbilityRegistry.ROUGH_SKIN).ev(BattleStatsType.HP, 4).moves(AttackRegistry.LUCKY_CHANT, AttackRegistry.SPIKES, AttackRegistry.TOXIC, AttackRegistry.PROTECT).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(2);
            });
            controller.takeFullTurn(() -> {
                teamA.switchPokemon(magikarp, clefable);
                teamB.attackOpponent(3);
            });
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(2);
                teamB.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(2);
            });
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(3);
                teamB.attackOpponent(4);
            });
            if (!teamA.asWrapper().hasFullHealth()) {
                return TestResult.failure("Magic Guard did not prevent all non attack damage");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPreventsLeechSeedHealing(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.MAGIC_GUARD).moves(AttackRegistry.MOONBLAST).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.FERROTHORN).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.LEECH_SEED).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            if (!teamA.asWrapper().hasFullHealth()) {
                return TestResult.failure("Magic Guard did not prevent damage");
            }
            if (teamB.asWrapper().hasFullHealth()) {
                return TestResult.failure("Magic Guard did not prevent healing from Leech Seed");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testMoldBreakerDoesNotSuppress(BattleTestHelper helper) {
        Pokemon clefable = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.MAGIC_GUARD).moves(AttackRegistry.DOUBLE_EDGE).build();
        Pokemon magikarp = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.SPLASH).build();
        TestParticipant teamA = helper.createParticipant(magikarp, clefable);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HAXORUS).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.STEALTH_ROCK, AttackRegistry.ROAR).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                teamA.switchPokemon(magikarp, clefable);
                teamA.attackOpponent(1);
                teamB.attackOpponent(2);
            });
            if (!teamA.asWrapper().hasFullHealth()) {
                return TestResult.failure("Magic Guard did not prevent all non attack damage because it was incorrectly suppressed by mold breaker");
            }
            return TestResult.success();
        });
    }
}

