/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class MagicBounceTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBouncesGrowl(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BULBASAUR).ability(AbilityRegistry.OVERGROW).moves(AttackRegistry.GROWL).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESPEON).ability(AbilityRegistry.MAGIC_BOUNCE).moves(AttackRegistry.FUTURE_SIGHT).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackOpponent(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Magic Bounce did not bounce Growl");
            }
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Magic Bounce did not bounce Growl - checking magic bounce user");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBouncesOnceWhenTargetAndSourceShareAbility(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.XATU).ability(AbilityRegistry.MAGIC_BOUNCE).moves(AttackRegistry.ROOST).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESPEON).ability(AbilityRegistry.MAGIC_BOUNCE).moves(AttackRegistry.GROWL).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Magic Bounce did not bounce Roost");
            }
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Magic Bounce did not bounce Growl");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotCauseChoiceLock(BattleTestHelper helper) {
        Pokemon xatu = helper.createDefaultPokemon(PixelmonSpecies.XATU).heldItem(PixelmonItems.choice_scarf).ability(AbilityRegistry.MAGIC_BOUNCE).moves(AttackRegistry.ROOST, AttackRegistry.GROWL).build();
        Pokemon spoink = helper.createDefaultPokemon(PixelmonSpecies.SPOINK).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.BOUNCE).build();
        TestParticipant teamA = helper.createParticipant(spoink, xatu);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESPEON).ability(AbilityRegistry.MAGIC_BOUNCE).moves(AttackRegistry.GROWL, AttackRegistry.RECOVER).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.switchPokemon(spoink, xatu);
                teamB.attackOpponent(1);
            });
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(2);
            });
            if (teamA.asWrapper().lastAttack.isAttack(AttackRegistry.GROWL)) {
                return TestResult.failure("Magic Bounce caused a choice lock");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testMoldBreakerSuppression(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BULBASAUR).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.GROWL).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESPEON).ability(AbilityRegistry.MAGIC_BOUNCE).moves(AttackRegistry.FUTURE_SIGHT).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackOpponent(1);
            teamB.attackSelf(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Magic Bounce was not suppressed by Mold Breaker");
            }
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Magic Bounce was not suppressed by Mold Breaker");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotBounceMovesWhenSemiInvulnerable(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BULBASAUR).ability(AbilityRegistry.OVERGROW).moves(AttackRegistry.GROWL).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.XATU).ability(AbilityRegistry.MAGIC_BOUNCE).moves(AttackRegistry.FLY).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackOpponent(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Magic Bounce bounced when it shouldn't due to semi-invulnerability");
            }
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Magic Bounce bounced when it shouldn't due to semi-invulnerability");
            }
            return TestResult.success();
        });
    }
}

