/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class LiquidOozeTests {
    @BattleTest
    public static CompletableFuture<TestResult> testDamagesTargetAfterDrainingMove(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TENTACRUEL).ability(AbilityRegistry.LIQUID_OOZE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SERPERIOR).moves(AttackRegistry.GIGA_DRAIN).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamB.asWrapper().hasFullHealth()) {
                return TestResult.failure("Liquid Ooze did not damage as retaliation for draining move when it should have");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDamagesTargetAfterLeechSeed(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TENTACRUEL).ability(AbilityRegistry.LIQUID_OOZE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SERPERIOR).moves(AttackRegistry.LEECH_SEED).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamB.asWrapper().hasFullHealth()) {
                return TestResult.failure("Liquid Ooze did not damage as retaliation for leech seed when it should have");
            }
            return TestResult.success();
        });
    }
}

