/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class LightningRodTests {
    @BattleTest
    public static CompletableFuture<TestResult> testGrantsImmunityToElectricTypeMovesAndBoostSpecialAttackByOne(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MANECTRIC).ability(AbilityRegistry.LIGHTNING_ROD).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.JOLTEON).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            attacker.attackOpponent(1);
            defender.attackOpponent(1);
            controller.takeFullTurn();
            if (!attacker.asWrapper().hasFullHealth()) {
                return TestResult.failure("Lightning Rod did not grant immunity to Electric-type moves.");
            }
            if (attacker.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("Lightning Rod did not boost Special Attack by one stage.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotBoostSpecialAttackIfAlreadyElectricTypeImmune(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RHYDON).ability(AbilityRegistry.LIGHTNING_ROD).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.JOLTEON).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            attacker.attackOpponent(1);
            defender.attackOpponent(1);
            controller.takeFullTurn();
            if (!attacker.asWrapper().hasFullHealth()) {
                return TestResult.failure("Ground type did not grant immunity to Electric-type moves.");
            }
            if (attacker.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) == 1) {
                return TestResult.failure("Lightning Rod should not boost Special Attack by one stage as Rhydon is already immune to electric type moves.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldRedirectSingleTargetElectricAttacksIfValidTarget(BattleTestHelper helper) {
        Pokemon lightningRod = helper.createDefaultPokemon(PixelmonSpecies.MANECTRIC).ability(AbilityRegistry.LIGHTNING_ROD).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        TestParticipant attacker = helper.createParticipant(3, lightningRod, attacker1, attacker2);
        Pokemon defender1 = helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        Pokemon defender2 = helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        Pokemon defender3 = helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        TestParticipant defender = helper.createParticipant(3, defender1, defender2, defender3);
        return helper.setupTripleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(lightningRod, 1, defender1);
                attacker.attackTarget(attacker1, 1, defender2);
                attacker.attackTarget(attacker2, 1, defender3);
                defender.attackTarget(defender1, 1, lightningRod);
                defender.attackTarget(defender2, 1, attacker1);
                defender.attackTarget(defender3, 1, attacker2);
            });
            if (attacker.asWrapper(lightningRod).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 3) {
                return TestResult.failure("Lightning rod should redirect single target electric attacks if valid target");
            }
            if (attacker.asWrapper(attacker2).hasFullHealth() || defender.asWrapper(defender3).hasFullHealth()) {
                return TestResult.failure("Lightning rod should redirect single target electric attacks if valid target");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldRedirectToTheFastestLightningRodUser(BattleTestHelper helper) {
        Pokemon fast = helper.createDefaultPokemon(PixelmonSpecies.MANECTRIC).ability(AbilityRegistry.LIGHTNING_ROD).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon slow = helper.createDefaultPokemon(PixelmonSpecies.MANECTRIC).ability(AbilityRegistry.LIGHTNING_ROD).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant lightningRod = helper.createParticipant(2, fast, slow);
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        return helper.setupDoubleBattleBuilder(attacker, lightningRod).forceChance().start().thenApply(controller -> {
            lightningRod.asWrapper(fast).getBattleStats().modifyStat(6, BattleStatsType.SPEED);
            controller.takeFullTurn(() -> {
                attacker.attackTarget(attacker1, 1, fast);
                attacker.attackTarget(attacker2, 1, slow);
                lightningRod.attackTarget(fast, 1, attacker1);
                lightningRod.attackTarget(slow, 1, attacker2);
            });
            if (lightningRod.asWrapper(fast).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 2) {
                return TestResult.failure("Electric attacks should redirect to the faster user.");
            }
            if (lightningRod.asWrapper(slow).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("Electric attacks should redirect to the faster user.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldRedirectSingleTargetElectricAttacksToLongestTimeIfSpeedTied(BattleTestHelper helper) {
        Pokemon meloetta = helper.createDefaultPokemon(PixelmonSpecies.MELOETTA).ability(AbilityRegistry.SERENE_GRACE).moves(AttackRegistry.ROLE_PLAY).build();
        Pokemon lightningRod = helper.createDefaultPokemon(PixelmonSpecies.PIKACHU).ability(AbilityRegistry.LIGHTNING_ROD).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant attacker = helper.createParticipant(2, meloetta, lightningRod);
        Pokemon defender1 = helper.createDefaultPokemon(PixelmonSpecies.PICHU).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        Pokemon defender2 = helper.createDefaultPokemon(PixelmonSpecies.PICHU).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        TestParticipant defender = helper.createParticipant(2, defender1, defender2);
        return helper.setupDoubleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(meloetta, 1, defender1);
                attacker.attackTarget(lightningRod, 1, defender2);
                defender.attackTarget(defender1, 1, meloetta);
                defender.attackTarget(defender2, 1, lightningRod);
            });
            if (attacker.asWrapper(lightningRod).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 2 || attacker.asWrapper(meloetta).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("Electric attacks should redirect to the pokemon with ability who have longest time, if speed tied.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldNotRedirectIfFollowMeHasBeenUsed(BattleTestHelper helper) {
        Pokemon lightningRod = helper.createDefaultPokemon(PixelmonSpecies.MANECTRIC).ability(AbilityRegistry.LIGHTNING_ROD).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon follow = helper.createDefaultPokemon(PixelmonSpecies.MANECTRIC).ability(AbilityRegistry.STATIC).moves(AttackRegistry.FOLLOW_ME).build();
        TestParticipant targets = helper.createParticipant(2, lightningRod, follow);
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDERBOLT).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        return helper.setupDoubleBattleBuilder(attacker, targets).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(attacker1, 1, lightningRod);
                attacker.attackTarget(attacker2, 1, follow);
                targets.attackTarget(lightningRod, 1, attacker1);
                targets.attackSelf(follow, 1);
            });
            if (targets.asWrapper(lightningRod).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("Lightning Rod should not redirect attacks attracted by FollowMe");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testShouldBeSuppressedByMoldBreaker(BattleTestHelper helper) {
        Pokemon lightningRod = helper.createDefaultPokemon(PixelmonSpecies.MANECTRIC).ability(AbilityRegistry.LIGHTNING_ROD).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wall = helper.createDefaultPokemon(PixelmonSpecies.MANAPHY).ability(AbilityRegistry.HYDRATION).moves(AttackRegistry.TAIL_GLOW).build();
        TestParticipant targets = helper.createParticipant(2, lightningRod, wall);
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.HAXORUS).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.THUNDER_PUNCH).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.ZEKROM).ability(AbilityRegistry.TERAVOLT).moves(AttackRegistry.SHOCK_WAVE).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        return helper.setupDoubleBattleBuilder(attacker, targets).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackTarget(attacker1, 1, lightningRod);
                attacker.attackTarget(attacker2, 1, wall);
                targets.attackTarget(lightningRod, 1, attacker1);
                targets.attackTarget(wall, 1, attacker2);
            });
            if (targets.asWrapper(wall).hasFullHealth()) {
                return TestResult.failure("Lightning Rod should not redirect MoldBreaker impacted electric type moves");
            }
            if (targets.asWrapper(lightningRod).getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("Lightning Rod should not get boosted by MoldBreaker impacted electric type moves");
            }
            if (targets.asWrapper(lightningRod).hasFullHealth()) {
                return TestResult.failure("Lightning Rod should not be immune to MoldBreaker impacted electric type moves");
            }
            return TestResult.success();
        });
    }
}

