/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class KlutzTests {
    @BattleTest
    public static CompletableFuture<TestResult> testNegatesResidualHealingEvents(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LOPUNNY).ability(AbilityRegistry.KLUTZ).heldItem(PixelmonItems.leftovers).moves(AttackRegistry.BELLY_DRUM).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GIRATINA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.SHADOW_SNEAK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackSelf(1);
            controller.takeFullTurn();
            int targetDamage = teamA.asWrapper().getMaxHealth() / 2;
            int damage = teamA.asWrapper().getHealthDeficit();
            if (damage != targetDamage) {
                return TestResult.failure("Leftovers healed the Pokemon when it should not have");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPreventsItemConsumption(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LOPUNNY).ability(AbilityRegistry.KLUTZ).level(1).heldItem(PixelmonItems.sitrus_berry).moves(AttackRegistry.ENDURE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DEOXYS).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.PSYCHIC).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getHeldItem() != PixelmonItems.sitrus_berry) {
                return TestResult.failure("The Pokemon's held item was consumed when it should not have");
            }
            if (teamA.asWrapper().getHealth() != 1) {
                return TestResult.failure("The Pokemon ate its held item when it should not have");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testIgnoresEffectsOfMoveDisablingItems(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LOPUNNY).ability(AbilityRegistry.KLUTZ).heldItem(PixelmonItems.assault_vest).moves(AttackRegistry.PROTECT).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DEOXYS).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.PSYCHIC).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (!teamA.asWrapper().lastAttack.isAttack(AttackRegistry.PROTECT)) {
                return TestResult.failure("The Pokemon's held item prevented it from using the move even though it had Klutz");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotIngoreItemsPreventingRemoval(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENESECT).ability(AbilityRegistry.KLUTZ).heldItem(PixelmonItems.douse_drive).moves(AttackRegistry.CALM_MIND).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DEOXYS).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.TRICK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getHeldItem() != PixelmonItems.douse_drive) {
                return TestResult.failure("The Pokemon's held item was removed when it should not have been due to Klutz");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCausesFlingFailure(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LOPUNNY).ability(AbilityRegistry.KLUTZ).heldItem(PixelmonItems.sea_incense).moves(AttackRegistry.FLING).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DEOXYS).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.CALM_MIND).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackSelf(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getHeldItem() != PixelmonItems.sea_incense) {
                return TestResult.failure("The Pokemon's held item was removed when it should not have been due to Klutz");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testMegaEvolutionStillWorks(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LOPUNNY).ability(AbilityRegistry.KLUTZ).heldItem(PixelmonItems.lopunnite).moves(AttackRegistry.PROTECT).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DEOXYS).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.CALM_MIND).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackSelf(1);
                teamA.asWrapper().willEvolve = true;
            });
            if (!teamA.asWrapper().getForm().is("mega")) {
                return TestResult.failure("Klutz erroneously prevented the Pokemon from mega evolving");
            }
            return TestResult.success();
        });
    }
}

