/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class IntrepidSwordBattleTests {
    @BattleTest
    public static CompletableFuture<TestResult> testOnlyIncreasesAttackOnce(BattleTestHelper helper) {
        Pokemon zacian = helper.createDefaultPokemon(PixelmonSpecies.ZACIAN).ability(AbilityRegistry.INTREPID_SWORD).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant teamA = helper.createParticipant(zacian, wynaut);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("Intrepid Sword did not increase the attack of the Pokemon by one stage");
            }
            controller.takeFullTurn(() -> {
                teamB.attackSelf(1);
                teamA.switchPokemon(zacian, wynaut);
            });
            controller.takeFullTurn(() -> {
                teamB.attackSelf(1);
                teamA.switchPokemon(zacian, wynaut);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Intrepid Sword increased the attack of the Pokemon multiple times when it should only increase it once");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testOnlyIncreasesAttackOnceWhenSwitchInWithMaxAttack(BattleTestHelper helper) {
        Pokemon zacian = helper.createDefaultPokemon(PixelmonSpecies.ZACIAN).ability(AbilityRegistry.INTREPID_SWORD).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.BELLY_DRUM, AttackRegistry.BATON_PASS).build();
        TestParticipant teamA = helper.createParticipant(wynaut, zacian);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamB.attackSelf(1);
                teamA.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                teamB.attackSelf(1);
                teamA.attackSelf(2);
                teamA.switchPokemon(wynaut, zacian);
            });
            controller.takeFullTurn(() -> {
                teamB.attackSelf(1);
                teamA.switchPokemon(zacian, wynaut);
            });
            controller.takeFullTurn(() -> {
                teamB.attackSelf(1);
                teamA.switchPokemon(wynaut, zacian);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Intrepid Sword increased the attack of Zacian even though it switched in with +6 attack");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotUseUpOneUseWhenSuppressed(BattleTestHelper helper) {
        Pokemon zacian = helper.createDefaultPokemon(PixelmonSpecies.ZACIAN).ability(AbilityRegistry.INTREPID_SWORD).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.BATON_PASS).build();
        TestParticipant teamA = helper.createParticipant(wynaut, zacian);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.GASTRO_ACID).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamB.attackOpponent(2);
                teamA.attackSelf(1);
                teamA.switchPokemon(wynaut, zacian);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Intrepid Sword increased the attack of Zacian even though it was suppressed");
            }
            controller.takeFullTurn(() -> {
                teamB.attackSelf(1);
                teamA.switchPokemon(zacian, wynaut);
            });
            controller.takeFullTurn(() -> {
                teamB.attackSelf(1);
                teamA.switchPokemon(wynaut, zacian);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("Intrepid Sword did not increase the attack of Zacian even though it was no longer suppressed");
            }
            return TestResult.success();
        });
    }
}

