/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.battles.BattleStatStageModifyBattleEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

@BattleTestClass
public class IntimidateTests {
    @BattleTest
    public static CompletableFuture<TestResult> testDecreases(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.SKETCH).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackSelf(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Intimidate did not decrease the attack of the opposing Pokemon by one stage");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotDecreaseAttackForOwnTempo(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.OWN_TEMPO).moves(AttackRegistry.SKETCH).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackSelf(1);
            teamB.attackSelf(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == -1) {
                return TestResult.failure("Intimidate decreased the attack of the opposing Pokemon by one stage, even though it had Own Tempo");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBlockedBySubstitute(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ESCAVALIER).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SUBSTITUTE).heldItem(PixelmonItems.leftovers).build());
        Pokemon gyarados = helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SPLASH).heldItem(PixelmonItems.leftovers).build();
        Pokemon greninja = helper.createDefaultPokemon(PixelmonSpecies.GRENINJA).ability(AbilityRegistry.PROTEAN).moves(AttackRegistry.U_TURN).heldItem(PixelmonItems.lagging_tail).build();
        TestParticipant teamB = helper.createParticipant(greninja, gyarados);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackSelf(1);
                teamB.switchPokemon(greninja, gyarados);
            });
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == -1) {
                return TestResult.failure("Intimidate decreased the attack of the opposing Pokemon by one stage, even though it was blocked by Substitute");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWaitUntilAllSwitchInsAtStartOfBattleAreComplete(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.MORNING_SUN).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilderWithoutSwitchIns(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            AtomicInteger intimidateCount = new AtomicInteger(0);
            AtomicBoolean orderCorrect = new AtomicBoolean(true);
            helper.skipTicks((BattleController)controller, 1);
            controller.addPersistentTaskAtEvent(BattleStatStageModifyBattleEvent.Pre.class, (event, battleController) -> {
                orderCorrect.set(event.getSource().pokemon.getSpecies().is(intimidateCount.get() == 0 ? PixelmonSpecies.ARCANINE : PixelmonSpecies.GYARADOS));
                intimidateCount.getAndIncrement();
            });
            helper.skipTicks((BattleController)controller, 10);
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackSelf(1);
            });
            if (intimidateCount.get() != 2) {
                return TestResult.failure("Intimidate did not activate twice instead got " + intimidateCount.get());
            }
            if (!orderCorrect.get()) {
                return TestResult.failure("Intimidate activated in the wrong order");
            }
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Intimidate did not decrease the attack of the opposing Pokemon by one stage");
            }
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Intimidate did not decrease the attack of the opposing Pokemon by one stage");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWaitUntilAllSwitchInsAtStartOfBattleAreCompleteReverseOrder(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.MORNING_SUN).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilderWithoutSwitchIns(teamB, teamA).forceChance().noCrits().start().thenApply(controller -> {
            AtomicInteger intimidateCount = new AtomicInteger(0);
            AtomicBoolean orderCorrect = new AtomicBoolean(true);
            helper.skipTicks((BattleController)controller, 1);
            controller.addPersistentTaskAtEvent(BattleStatStageModifyBattleEvent.Pre.class, (event, battleController) -> {
                orderCorrect.set(event.getSource().pokemon.getSpecies().is(intimidateCount.get() == 0 ? PixelmonSpecies.ARCANINE : PixelmonSpecies.GYARADOS));
                intimidateCount.getAndIncrement();
            });
            helper.skipTicks((BattleController)controller, 10);
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackSelf(1);
            });
            if (intimidateCount.get() != 2) {
                return TestResult.failure("Intimidate did not activate twice instead got " + intimidateCount.get());
            }
            if (!orderCorrect.get()) {
                return TestResult.failure("Intimidate activated in the wrong order");
            }
            if (teamA.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Intimidate did not decrease the attack of the opposing Pokemon by one stage");
            }
            if (teamB.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Intimidate did not decrease the attack of the opposing Pokemon by one stage");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWaitUntilAllSwitchInsAtStartOfTurnAreComplete(BattleTestHelper helper) {
        Pokemon starterA = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).moves(AttackRegistry.SPLASH).build();
        Pokemon starterB = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).moves(AttackRegistry.SPLASH).build();
        Pokemon arcanine = helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.MORNING_SUN).build();
        Pokemon gyarados = helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SPLASH).build();
        TestParticipant teamA = helper.createParticipant(starterA, arcanine);
        TestParticipant teamB = helper.createParticipant(starterB, gyarados);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.switchPokemon(starterA, arcanine);
                teamB.switchPokemon(starterB, gyarados);
            });
            if (teamA.asWrapper(arcanine).getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Intimidate did not decrease the attack of the opposing Pokemon by one stage");
            }
            if (teamB.asWrapper(gyarados).getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Intimidate did not target the switched in pokemon after switching in first");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWaitUntilAllSwitchInsAfterFaintsAreComplete(BattleTestHelper helper) {
        Pokemon starterA = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).moves(AttackRegistry.EXPLOSION).build();
        Pokemon starterB = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).level(1).moves(AttackRegistry.SPLASH).build();
        Pokemon arcanine = helper.createDefaultPokemon(PixelmonSpecies.ARCANINE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.MORNING_SUN).build();
        Pokemon gyarados = helper.createDefaultPokemon(PixelmonSpecies.GYARADOS).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SPLASH).build();
        TestParticipant teamA = helper.createParticipant(starterA, arcanine);
        TestParticipant teamB = helper.createParticipant(starterB, gyarados);
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackOpponent(1);
                teamB.attackOpponent(1);
                teamA.switchPokemon(starterA, arcanine);
                teamB.switchPokemon(starterB, gyarados);
            });
            if (teamA.asWrapper(arcanine).getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Intimidate did not decrease the attack of the opposing Pokemon by one stage");
            }
            if (teamB.asWrapper(gyarados).getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Intimidate did not target the switched in pokemon after switching in first");
            }
            return TestResult.success();
        });
    }
}

