/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ImmunityTests {
    @BattleTest
    public static CompletableFuture<TestResult> testUserImmuneToPoison(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SNORLAX).ability(AbilityRegistry.IMMUNITY).moves(AttackRegistry.CURSE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CROBAT).ability(AbilityRegistry.INFILTRATOR).moves(AttackRegistry.TOXIC).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackOpponent(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getStatus(StatusType.PoisonBadly) != null) {
                return TestResult.failure("Snorlax was poisoned by Toxic even though it had Immunity");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCurePoisonWhenReceivedAbility(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SNORLAX).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.CURSE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CROBAT).ability(AbilityRegistry.IMMUNITY).moves(AttackRegistry.TOXIC, AttackRegistry.SKILL_SWAP).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackOpponent(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getStatus(StatusType.PoisonBadly) == null) {
                return TestResult.failure("Snorlax was not poisoned... but should have been!");
            }
            teamA.attackOpponent(1);
            teamB.attackOpponent(2);
            controller.takeFullTurn();
            if (teamA.asWrapper().getStatus(StatusType.PoisonBadly) != null) {
                return TestResult.failure("Snorlax was not cured of poison after receiving Immunity");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSupressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant teamA = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SNORLAX).ability(AbilityRegistry.IMMUNITY).moves(AttackRegistry.CURSE).build());
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CROBAT).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.TOXIC).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            teamA.attackOpponent(1);
            teamB.attackOpponent(1);
            controller.takeFullTurn();
            if (teamA.asWrapper().getStatus(StatusType.PoisonBadly) != null) {
                return TestResult.failure("Snorlax's Immunity did not properly cure the poison after it was hit by toxic and initially suppressed");
            }
            return TestResult.success();
        });
    }
}

