/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class GuardDogTests {
    @BattleTest
    public static CompletableFuture<TestResult> testNullifiesIntimidateAndBoostsAttack(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MABOSSTIFF).ability(AbilityRegistry.GUARD_DOG).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SANDILE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(attacker, defense).forceChance().noCrits().start().thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackSelf(1);
            controller.takeFullTurn();
            if (attacker.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("Guard Dog did not boost the attack stat by 1 expected 1 but was " + attacker.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK));
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPreventsPhasing(BattleTestHelper helper) {
        Pokemon guardDog = helper.createDefaultPokemon(PixelmonSpecies.MABOSSTIFF).ability(AbilityRegistry.GUARD_DOG).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon azumarill = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.ROLLOUT).build();
        TestParticipant teamA = helper.createParticipant(1, guardDog, azumarill);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHINX).ability(AbilityRegistry.RIVALRY).moves(AttackRegistry.ROAR).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
                teamA.switchPokemon(guardDog, azumarill);
            });
            if (!teamA.asWrapper((Pokemon)guardDog).onBattlefield) {
                return TestResult.failure("Guard Dog did not prevent Roar from causing a switch");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSuppressedByMoldBreaker(BattleTestHelper helper) {
        Pokemon guardDog = helper.createDefaultPokemon(PixelmonSpecies.MABOSSTIFF).ability(AbilityRegistry.GUARD_DOG).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon azumarill = helper.createDefaultPokemon(PixelmonSpecies.AZUMARILL).ability(AbilityRegistry.THICK_FAT).moves(AttackRegistry.ROLLOUT).build();
        TestParticipant teamA = helper.createParticipant(1, guardDog, azumarill);
        TestParticipant teamB = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHINX).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.ROAR).build());
        return helper.setupSingleBattleBuilder(teamA, teamB).forceChance().noCrits().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                teamA.attackSelf(1);
                teamB.attackOpponent(1);
                teamA.switchPokemon(guardDog, azumarill);
            });
            if (teamA.asWrapper((Pokemon)guardDog).onBattlefield) {
                return TestResult.failure("Guard Dog prevented Roar from causing a switch even though mold breaker was active");
            }
            return TestResult.success();
        });
    }
}

