/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class GluttonyTests {
    @BattleTest
    public static CompletableFuture<TestResult> testActivatesAguavAtHalfHealth(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WOBBUFFET).ability(AbilityRegistry.GLUTTONY).heldItem(PixelmonItems.aguav_berry).moves(AttackRegistry.SLEEP_TALK).ev(BattleStatsType.HP, 4).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.SUPER_FANG).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            int targetHealth = attacker.asWrapper().getMaxHealth() / 2 + attacker.asWrapper().getMaxHealth() / 3;
            int health = attacker.asWrapper().getHealth();
            if (targetHealth != health) {
                return TestResult.failure("Gluttony did not activate the Aguav Berry at half health expected " + targetHealth + " but was " + health);
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testActivatesAfterBellyDrum(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SNORLAX).ability(AbilityRegistry.GLUTTONY).heldItem(PixelmonItems.aguav_berry).moves(AttackRegistry.BELLY_DRUM).ev(BattleStatsType.HP, 4).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackSelf(1);
            controller.takeFullTurn();
            int targetHealth = attacker.asWrapper().getMaxHealth() / 2 + attacker.asWrapper().getMaxHealth() / 3;
            int health = attacker.asWrapper().getHealth();
            if (targetHealth != health) {
                return TestResult.failure("Gluttony did not activate the Aguav Berry at half health from belly drum expected " + targetHealth + " but was " + health);
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testActivatesAfterPoisonDamage(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WOBBUFFET).ability(AbilityRegistry.GLUTTONY).heldItem(PixelmonItems.aguav_berry).moves(AttackRegistry.SLEEP_TALK).ev(BattleStatsType.HP, 28).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.POISON_POWDER).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            int health;
            for (int i = 0; i < 4; ++i) {
                attacker.attackSelf(1);
                defense.attackOpponent(1);
                controller.takeFullTurn();
            }
            int targetHealth = attacker.asWrapper().getMaxHealth() / 2 + attacker.asWrapper().getMaxHealth() / 3;
            if (targetHealth != (health = attacker.asWrapper().getHealth())) {
                return TestResult.failure("Gluttony did not activate the Aguav Berry at half health from poison expected " + targetHealth + " but was " + health);
            }
            return TestResult.success();
        });
    }
}

