/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.BattleMessageAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class FriskTests {
    @BattleTest
    public static CompletableFuture<TestResult> testRevealsOpposingItems(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.DUSCLOPS).ability(AbilityRegistry.FRISK).moves(AttackRegistry.SNORE).build(), helper.createDefaultPokemon(PixelmonSpecies.DUSKULL).ability(AbilityRegistry.LEVITATE).moves(AttackRegistry.SNORE).build());
        TestParticipant defense = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.SPECTRIER).ability(AbilityRegistry.GRIM_NEIGH).heldItem(PixelmonItems.choice_specs).moves(AttackRegistry.SHADOW_BALL).build(), helper.createDefaultPokemon(PixelmonSpecies.GLASTRIER).ability(AbilityRegistry.CHILLING_NEIGH).heldItem(PixelmonItems.choice_band).moves(AttackRegistry.AVALANCHE).build());
        return helper.setupDoubleBattleBuilder(attacker, defense).forceChance().start().thenApply(controller -> {
            controller.doTurnLogic();
            controller.doTurnLogic();
            String choiceSpecs = controller.battleLog.getAllActions().stream().filter(BattleMessageAction.class::isInstance).map(battleAction -> ((BattleMessageAction)battleAction).getMessage()).filter(message -> message.contains("Choice Specs")).findFirst().orElse(null);
            if (choiceSpecs == null) {
                return TestResult.failure("Frisk did not reveal the Choice Specs held item");
            }
            String choiceBand = controller.battleLog.getAllActions().stream().filter(BattleMessageAction.class::isInstance).map(battleAction -> ((BattleMessageAction)battleAction).getMessage()).filter(message -> message.contains("Choice Band")).findFirst().orElse(null);
            if (choiceBand == null) {
                return TestResult.failure("Frisk did not reveal the Choice Band held item");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testNeutralizingGasInteraction(BattleTestHelper helper) {
        Pokemon duskclops = helper.createDefaultPokemon(PixelmonSpecies.DUSCLOPS).ability(AbilityRegistry.FRISK).moves(AttackRegistry.SNORE).build();
        Pokemon duskull = helper.createDefaultPokemon(PixelmonSpecies.DUSKULL).ability(AbilityRegistry.LEVITATE).moves(AttackRegistry.SNORE).build();
        TestParticipant attacker = helper.createParticipant(2, duskclops, duskull);
        Pokemon pikachu = helper.createDefaultPokemon(PixelmonSpecies.PIKACHU).ability(AbilityRegistry.STATIC).heldItem(PixelmonItems.light_ball).moves(AttackRegistry.SNORE).build();
        Pokemon weezing = helper.createDefaultPokemon(PixelmonSpecies.WEEZING).ability(AbilityRegistry.NEUTRALIZING_GAS).heldItem(PixelmonItems.choice_band).moves(AttackRegistry.EXPLOSION).build();
        Pokemon pichu = helper.createDefaultPokemon(PixelmonSpecies.PICHU).ability(AbilityRegistry.STATIC).moves(AttackRegistry.SNORE).build();
        TestParticipant defense = helper.createParticipant(2, pikachu, weezing, pichu);
        return helper.setupDoubleBattleBuilder(attacker, defense).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackSelf(duskull, 1);
                attacker.attackSelf(duskclops, 1);
                defense.attackSelf(pikachu, 1);
                defense.attackOpponent(weezing, 1);
                defense.switchPokemon(weezing, pichu);
            });
            String reveal = controller.battleLog.getAllActions().stream().filter(BattleMessageAction.class::isInstance).map(battleAction -> ((BattleMessageAction)battleAction).getMessage()).filter(message -> message.contains("frisked")).findFirst().orElse(null);
            if (reveal != null) {
                return TestResult.failure("Frisk should not have revealed the held item of the opposing Pok\u00e9mon when Neutralizing Gas was active or after it was active!");
            }
            return TestResult.success();
        });
    }
}

