/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.Freeze;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class FlashFireTests {
    @BattleTest
    public static CompletableFuture<TestResult> testGrantsImmunityToFireTypeMovesAndIncreasesFireTypeAttacksByHalf(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.INCINERATE).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TALONFLAME).ability(AbilityRegistry.GALE_WINGS).moves(AttackRegistry.FLARE_BLITZ).build());
        return helper.setupSingleBattleBuilder(attacker, defense).forceChance().noCrits().start().thenApply(controller -> {
            attacker.attackOpponent(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            if (!attacker.asWrapper().hasFullHealth()) {
                return TestResult.failure("Immunity was not granted by Flash Fire against fire type moves");
            }
            if (!helper.inRange(attacker.asWrapper().lastAttack.moveResult.getDamage(), 82, 98)) {
                return TestResult.failure("Flash Fire did not increase the damage of Incinerate by 50% expected in [82, 98] but was " + attacker.asWrapper().lastAttack.moveResult.getDamage());
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testGrantsImmunityToFireTypeMovesEvenWhenFrozen(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TALONFLAME).ability(AbilityRegistry.GALE_WINGS).moves(AttackRegistry.FLARE_BLITZ).build());
        return helper.setupSingleBattleBuilder(attacker, defense).forceChance().noCrits().start().thenApply(controller -> {
            attacker.asWrapper().addStatus(new Freeze(), defense.asWrapper());
            attacker.attackSelf(1);
            defense.attackOpponent(1);
            controller.advanceToMoves();
            controller.doTurnLogic();
            if (!attacker.asWrapper().hasFullHealth()) {
                return TestResult.failure("Immunity was not granted by Flash Fire against fire type moves when frozen");
            }
            if (!attacker.asWrapper().hasStatus(StatusType.Freeze)) {
                return TestResult.failure("Flash Fire did not prevent Thawing from being hit by a Fire-type move");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testImmunitySupressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.INCINERATE).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HAXORUS).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.FIRE_PUNCH).build());
        return helper.setupSingleBattleBuilder(attacker, defense).forceChance().noCrits().start().thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            if (attacker.asWrapper().hasFullHealth()) {
                return TestResult.failure("Immunity was granted by Flash Fire against fire type moves when Mold Breaker was active");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBoostLostAfterAbilityChange(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.INCINERATE).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TALONFLAME).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.FLAMETHROWER, AttackRegistry.WORRY_SEED).build());
        return helper.setupSingleBattleBuilder(attacker, defense).forceChance().noCrits().start().thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            attacker.attackOpponent(2);
            defense.attackOpponent(2);
            controller.takeFullTurn();
            int damage = defense.asWrapper().getHealthDeficit();
            if (!helper.inRange(damage, 54, 66)) {
                return TestResult.failure("Flash Fire's damage was incorrect expected in [54, 66] but was " + damage);
            }
            return TestResult.success();
        });
    }
}

