/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class EmergencyExitTests {
    @BattleTest
    public static CompletableFuture<TestResult> testSwitchOutRequestIfDamagedBelowHalfHP(BattleTestHelper helper) {
        Pokemon golisopod = helper.createDefaultPokemon(PixelmonSpecies.GOLISOPOD).ability(AbilityRegistry.EMERGENCY_EXIT).level(85).moves(AttackRegistry.BULK_UP).ivs(0, 0, 0, 0, 0, 0).build();
        Pokemon clefable = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant attacker = helper.createParticipant(golisopod, clefable);
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RATICATE).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.SUPER_FANG).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackSelf(1);
                attacker.switchPokemon(golisopod, clefable);
                defender.attackOpponent(1);
            });
            if (!defender.asWrapper().hasFullHealth()) {
                return TestResult.failure("Emergency Exit did not switch out Golisopod when it was damaged below half HP");
            }
            if (!helper.atMost(attacker.asWrapper(golisopod).getHealth(), golisopod.getMaxHealth() / 2)) {
                return TestResult.failure("Golisopod did not take enough damage to trigger Emergency Exit expected at most " + golisopod.getMaxHealth() / 2 + " but got " + attacker.asWrapper(golisopod).getHealth());
            }
            if (!attacker.asWrapper((Pokemon)clefable).onBattlefield) {
                return TestResult.failure("Emergency Exit did not switch out Golisopod when it was damaged below half HP");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSwitchesOutAtEndOfMultiHitMoves(BattleTestHelper helper) {
        Pokemon golisopod = helper.createDefaultPokemon(PixelmonSpecies.GOLISOPOD).ability(AbilityRegistry.EMERGENCY_EXIT).level(60).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon clefable = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.UNAWARE).moves(AttackRegistry.METRONOME).build();
        TestParticipant attacker = helper.createParticipant(golisopod, clefable);
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CINCCINO).ability(AbilityRegistry.SKILL_LINK).moves(AttackRegistry.BULLET_SEED).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackSelf(1);
                attacker.switchPokemon(golisopod, clefable);
                defender.attackOpponent(1);
            });
            if (!attacker.asWrapper((Pokemon)clefable).onBattlefield) {
                return TestResult.failure("Emergency Exit did not switch out Golisopod when it was damaged below half HP");
            }
            if (!attacker.asWrapper(clefable).hasFullHealth()) {
                return TestResult.failure("Emergency Exit did not wait until the end of the multi hit move!");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSwitchesOutIfDamagedByResidualDamage(BattleTestHelper helper) {
        Pokemon mew = helper.createDefaultPokemon(PixelmonSpecies.MEW).ability(AbilityRegistry.EMERGENCY_EXIT).moves(AttackRegistry.SPLASH).build();
        Pokemon shaymin = helper.createDefaultPokemon(PixelmonSpecies.SHAYMIN).moves(AttackRegistry.SPLASH).build();
        TestParticipant attacker = helper.createParticipant(mew, shaymin);
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CROBAT).moves(AttackRegistry.TOXIC).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            attacker.asWrapper(mew).setHealth(mew.getMaxHealth() / 2 + 2);
            controller.takeFullTurn(() -> {
                attacker.attackSelf(1);
                attacker.switchPokemon(mew, shaymin);
                defender.attackOpponent(1);
            });
            if (!attacker.asWrapper((Pokemon)shaymin).onBattlefield) {
                return TestResult.failure("Emergency Exit did not switch out Mew when it was damaged below half HP");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSwitchesOutIfBelowHalfHPFromProtonGeyser(BattleTestHelper helper) {
        Pokemon charmeleon = helper.createDefaultPokemon(PixelmonSpecies.CHARMELEON).ability(AbilityRegistry.EMERGENCY_EXIT).moves(AttackRegistry.SPLASH).build();
        Pokemon shaymin = helper.createDefaultPokemon(PixelmonSpecies.SHAYMIN).moves(AttackRegistry.SPLASH).build();
        TestParticipant attacker = helper.createParticipant(charmeleon, shaymin);
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).moves(AttackRegistry.PHOTON_GEYSER).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                attacker.switchPokemon(charmeleon, shaymin);
                defender.attackOpponent(1);
            });
            if (!attacker.asWrapper((Pokemon)shaymin).onBattlefield) {
                return TestResult.failure("Emergency Exit did not switch out Mew when it was brought below half HP by Photon Geyser");
            }
            return TestResult.success();
        });
    }
}

