/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class DrySkinTests {
    @BattleTest
    public static CompletableFuture<TestResult> testTakesOneEigthOfMaxHPEveryTurnSunnyDayActive(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TOXICROAK).ability(AbilityRegistry.DRY_SKIN).moves(AttackRegistry.BULK_UP).build());
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NINETALES).ability(AbilityRegistry.FLASH_FIRE).moves(AttackRegistry.SUNNY_DAY).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            attacker.attackSelf(1);
            defender.attackSelf(1);
            controller.takeFullTurn();
            if (attacker.asWrapper().getHealth() == attacker.asWrapper().getMaxHealth() * 7 / 8) {
                return TestResult.failure("Dry Skin did not damage Toxic Croak for 1/8 of its max HP");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testHealsOneEigthMaxHpWithRainDance(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TOXICROAK).ability(AbilityRegistry.DRY_SKIN).moves(AttackRegistry.SUBSTITUTE).build());
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.POLITOED).ability(AbilityRegistry.DAMP).moves(AttackRegistry.ENCORE, AttackRegistry.RAIN_DANCE).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            attacker.attackSelf(1);
            defender.attackSelf(1);
            controller.takeFullTurn();
            int preHealth = attacker.asWrapper().getHealth();
            attacker.attackSelf(1);
            defender.attackSelf(2);
            controller.takeFullTurn();
            int targetHealth = preHealth + attacker.asWrapper().getMaxHealth() / 8;
            int currentHealth = attacker.asWrapper().getHealth();
            if (currentHealth != targetHealth) {
                return TestResult.failure("Dry Skin did not heal Toxic Croak for 1/8 of its max HP");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testImmuneToWaterMovesAndHealQuarterHealth(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TOXICROAK).ability(AbilityRegistry.DRY_SKIN).moves(AttackRegistry.SUBSTITUTE).build());
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.POLITOED).ability(AbilityRegistry.DAMP).moves(AttackRegistry.WATER_GUN).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            attacker.attackSelf(1);
            defender.attackOpponent(1);
            controller.takeFullTurn();
            if (!attacker.asWrapper().hasFullHealth()) {
                return TestResult.failure("Dry Skin did not make Toxic Croak immune to Water Gun");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testFireDamageMultiplier(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TOXICROAK).ability(AbilityRegistry.DRY_SKIN).moves(AttackRegistry.BULK_UP).build());
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HAXORUS).ability(AbilityRegistry.UNNERVE).moves(AttackRegistry.INCINERATE).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().noCrits().start().thenApply(controller -> {
            attacker.attackSelf(1);
            defender.attackOpponent(1);
            controller.takeFullTurn();
            if (!helper.inRange(defender.asWrapper().lastAttack.moveResult.getDamage(), 51, 61)) {
                return TestResult.failure("Dry Skin did not multiply Incinerate damage by 1.25. Expected [51, 61] but instead got " + defender.asWrapper().lastAttack.moveResult.getDamage());
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TOXICROAK).ability(AbilityRegistry.DRY_SKIN).moves(AttackRegistry.BULK_UP).build());
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HAXORUS).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.INCINERATE, AttackRegistry.SURF).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().noCrits().start().thenApply(controller -> {
            attacker.attackSelf(1);
            defender.attackOpponent(1);
            controller.takeFullTurn();
            if (!helper.inRange(defender.asWrapper().lastAttack.moveResult.getDamage(), 41, 49)) {
                return TestResult.failure("Dry Skin was not suppressed by Mold Breaker. Expected [41, 49] but instead got " + defender.asWrapper().lastAttack.moveResult.getDamage());
            }
            int preHealth = attacker.asWrapper().getHealth();
            attacker.attackSelf(1);
            defender.attackOpponent(2);
            controller.takeFullTurn();
            if (preHealth == attacker.asWrapper().getHealth()) {
                return TestResult.failure("Dry Skin was not suppressed by Mold Breaker. Expected Toxic Croak to take damage from Surf");
            }
            return TestResult.success();
        });
    }
}

