/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class DisguiseTests {
    @BattleTest
    public static CompletableFuture<TestResult> testDisguiseWorks(BattleTestHelper helper) {
        TestParticipant mimikyu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.SPLASH).build());
        TestParticipant psyduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PSYDUCK).ability(AbilityRegistry.SWIFT_SWIM).moves(AttackRegistry.WATER_GUN).build());
        return helper.setupSingleBattleBuilder(mimikyu, psyduck).forceChance().start().thenApply(controller -> {
            mimikyu.attackOpponent(1);
            psyduck.attackOpponent(1);
            controller.takeFullTurn();
            if (mimikyu.asWrapper().getForm().isForm("disguised")) {
                return TestResult.failure("Mimikyu's disguise wasn't busted.");
            }
            if (mimikyu.asWrapper().getHealth() == mimikyu.asWrapper().getMaxHealth() * 7 / 8) {
                return TestResult.failure("Mimikyu didn't take 1/8 of its max HP in damage after the disguise busted.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDisguiseDoesntBlockMultipleHits(BattleTestHelper helper) {
        TestParticipant mimikyu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.SPLASH).build());
        TestParticipant wattrel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WATTREL).ability(AbilityRegistry.WIND_POWER).moves(AttackRegistry.DUAL_WINGBEAT).heldItem(PixelmonItems.life_orb).build());
        return helper.setupSingleBattleBuilder(mimikyu, wattrel).forceChance().start().thenApply(controller -> {
            mimikyu.attackOpponent(1);
            wattrel.attackOpponent(1);
            controller.takeFullTurn();
            if (mimikyu.asWrapper().getHealth() == mimikyu.asWrapper().getMaxHealth() * 6 / 8) {
                return TestResult.failure("Mimikyu's Disguise activated twice, making it take damage equal to 1/8 of its HP twice.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testSubstituteActivatesBeforeDisguise(BattleTestHelper helper) {
        TestParticipant mimikyu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.SUBSTITUTE).build());
        TestParticipant dragonite = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DRAGONITE).ability(AbilityRegistry.INNER_FOCUS).moves(AttackRegistry.FLAMETHROWER).build());
        return helper.setupSingleBattleBuilder(mimikyu, dragonite).forceChance().start().thenApply(controller -> {
            mimikyu.attackOpponent(1);
            dragonite.attackOpponent(1);
            controller.takeFullTurn();
            if (mimikyu.asWrapper().getForm().isForm("busted")) {
                return TestResult.failure("Mimikyu's Disguise took the damage before its Substitute.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDisguiseSuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant mimikyu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.SPLASH).build());
        TestParticipant haxorus = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HAXORUS).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.EARTHQUAKE).build());
        return helper.setupSingleBattleBuilder(mimikyu, haxorus).forceChance().start().thenApply(controller -> {
            mimikyu.attackOpponent(1);
            haxorus.attackOpponent(1);
            controller.takeFullTurn();
            if (mimikyu.asWrapper().getForm().isForm("busted")) {
                return TestResult.failure("Mold Breaker did not bypass the Disguise, and Mimikyu is now in Busted form.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDisguiseBypassedByStarterGMaxMoves(BattleTestHelper helper) {
        TestParticipant mimikyu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.SPLASH).heldItem(PixelmonItems.focus_sash).build());
        TestParticipant rillaboom = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RILLABOOM).ability(AbilityRegistry.OVERGROW).moves(AttackRegistry.BRANCH_POKE).gigantamaxFactor().build());
        return helper.setupSingleBattleBuilder(mimikyu, rillaboom).forceChance().start().thenApply(controller -> {
            rillaboom.evolve();
            mimikyu.attackOpponent(1);
            rillaboom.attackOpponent(1);
            controller.takeFullTurn();
            if (rillaboom.asWrapper().isDynamax != 2) {
                return TestResult.failure("Rillaboom didn't gigantamax");
            }
            if (mimikyu.asWrapper().getForm().isForm("busted")) {
                return TestResult.failure("G-Max Drum Solo did not bypass the Disguise, and Mimikyu is now in Busted form.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDisguisePreventsWeaknessPolicyActivating(BattleTestHelper helper) {
        TestParticipant mimikyu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.REFLECT_TYPE).heldItem(PixelmonItems.weakness_policy).build());
        TestParticipant haxorus = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HAXORUS).ability(AbilityRegistry.RIVALRY).moves(AttackRegistry.DRAGON_CLAW).heldItem(PixelmonItems.lagging_tail).build());
        return helper.setupSingleBattleBuilder(mimikyu, haxorus).forceChance().start().thenApply(controller -> {
            mimikyu.attackOpponent(1);
            haxorus.attackOpponent(1);
            controller.takeFullTurn();
            if (!mimikyu.asWrapper().hasHeldItem()) {
                return TestResult.failure("The Mimikyu's Weakness Policy got removed.");
            }
            for (int i : mimikyu.asWrapper().getBattleStats().getStages()) {
                if (i == 0) continue;
                return TestResult.failure("The Mimikyu's Weakness Policy raised its stats even though Disguise should prevent it from activating.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testAirBalloonStillPopsWhenDisguiseActivates(BattleTestHelper helper) {
        TestParticipant mimikyu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.SPLASH).heldItem(PixelmonItems.air_balloon).build());
        TestParticipant haxorus = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HAXORUS).ability(AbilityRegistry.RIVALRY).moves(AttackRegistry.CRUNCH).build());
        return helper.setupSingleBattleBuilder(mimikyu, haxorus).forceChance().start().thenApply(controller -> {
            mimikyu.attackOpponent(1);
            haxorus.attackOpponent(1);
            controller.takeFullTurn();
            if (mimikyu.asWrapper().isAirborne() || mimikyu.asWrapper().hasHeldItem()) {
                return TestResult.failure("The Mimikyu's Air Balloon didn't activate.");
            }
            if (mimikyu.asWrapper().getForm().isForm("disguised")) {
                return TestResult.failure("Mimikyu's disguise wasn't busted while testing for air balloon.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDisguiseDoesntBlockSecondaryEffects(BattleTestHelper helper) {
        TestParticipant mimikyu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.SPLASH).build());
        TestParticipant pikachu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PIKACHU).ability(AbilityRegistry.STATIC).moves(AttackRegistry.NUZZLE).build());
        return helper.setupSingleBattleBuilder(mimikyu, pikachu).forceChance().start().thenApply(controller -> {
            mimikyu.attackOpponent(1);
            pikachu.attackOpponent(1);
            controller.takeFullTurn();
            if (mimikyu.asWrapper().getForm().isForm("disguised")) {
                return TestResult.failure("Mimikyu's disguise wasn't busted while testing for secondary effects.");
            }
            if (!mimikyu.asWrapper().hasStatus(StatusType.Paralysis)) {
                return TestResult.failure("Mimikyu was not paralyzed from Nuzzle.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDisguiseRevertsTypesAfterSwitchingForm(BattleTestHelper helper) {
        TestParticipant mimikyu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.REFLECT_TYPE).build());
        TestParticipant pikachu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PIKACHU).ability(AbilityRegistry.STATIC).moves(AttackRegistry.THUNDER_SHOCK).build());
        return helper.setupSingleBattleBuilder(mimikyu, pikachu).forceChance().start().thenApply(controller -> {
            mimikyu.attackOpponent(1);
            pikachu.attackOpponent(1);
            controller.takeFullTurn();
            if (mimikyu.asWrapper().isSingleType() || mimikyu.asWrapper().hasType(Element.ELECTRIC)) {
                return TestResult.failure("Mimikyu's types didn't reset when its disguise was busted.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDisguiseCantBeUsedByDitto(BattleTestHelper helper) {
        TestParticipant mimikyu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MIMIKYU).ability(AbilityRegistry.DISGUISE).moves(AttackRegistry.PSYWAVE).build());
        TestParticipant ditto = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DITTO).ability(AbilityRegistry.IMPOSTER).moves(AttackRegistry.PSYWAVE).build());
        return helper.setupSingleBattleBuilder(mimikyu, ditto).forceChance().start().thenApply(controller -> {
            mimikyu.attackOpponent(1);
            ditto.attackOpponent(1);
            controller.takeFullTurn();
            if (ditto.asWrapper().getHealthDeficit() != 100) {
                return TestResult.failure("Ditto doesn't have exactly 100 health lost from Psywave. Disguise likely activated.");
            }
            return TestResult.success();
        });
    }
}

