/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.Sunny;
import com.pixelmonmod.pixelmon.battles.status.Weather;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class DesolateLandTests {
    @BattleTest
    public static CompletableFuture<TestResult> testDesolateLandWeatherActivesOnSwitchIn(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ABRA).ability(AbilityRegistry.MAGIC_GUARD).moves(AttackRegistry.TELEPORT).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            Weather patt1477$temp = controller.globalStatusController.getWeather();
            if (patt1477$temp instanceof Sunny) {
                Sunny sunny = (Sunny)patt1477$temp;
                if (sunny.extreme) {
                    return TestResult.success();
                }
            }
            return TestResult.failure("Desolate Land should activate on switch in");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDesolteLandIncreasesDamageOfFireAttacks(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NINETALES).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.INCINERATE).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CRYOGONAL).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.SPLASH).build());
        return helper.setupSingleBattleBuilder(attacker, defense).forceChance().start().thenApply(controller -> {
            attacker.attackAutoTarget(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            if (attacker.asWrapper().lastAttack.moveResult.getDamage() != 153) {
                return TestResult.failure("Desolate Land should increase the damage of Fire-type attacks expected 153 but instead got: " + attacker.asWrapper().lastAttack.moveResult.getDamage());
            }
            int modifiedFirePower = AttackRegistry.INCINERATE.getValueUnsafe().ofMutable().modifyMoveStats(attacker.asWrapper(), defense.asWrapper(), attacker.asWrapper().getBattleAbility(), defense.asWrapper().getBattleAbility(), AttackRegistry.INCINERATE.getValueUnsafe().getBasePower())[0];
            if (modifiedFirePower != attacker.asWrapper().pokemon.getMoveset().get((int)0).movePower) {
                return TestResult.failure("Desolate Land should increase the damage of Fire-type attacks power: " + modifiedFirePower + " expected power: " + attacker.asWrapper().pokemon.getMoveset().get((int)0).movePower);
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldCauseWaterTypeAttacksToFail(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLASTOISE).ability(AbilityRegistry.TORRENT).moves(AttackRegistry.SURF).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            if (!attacker.asWrapper().hasFullHealth()) {
                return TestResult.failure("Desolate Land should cause Water-type attacks to fail");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> shouldCauseWaterTypeStatusMovesToFail(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BLASTOISE).ability(AbilityRegistry.TORRENT).moves(AttackRegistry.SOAK).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            if (!attacker.asWrapper().hasFullHealth()) {
                return TestResult.failure("Desolate Land should cause Water-type status moves to fail");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTreatedAsSunnyDayForAnyFormsMoveOrAbility(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.HELPING_HAND, AttackRegistry.SOLAR_BEAM).build());
        Pokemon castForm = helper.createDefaultPokemon(PixelmonSpecies.CASTFORM).ability(AbilityRegistry.FORECAST).moves(AttackRegistry.WEATHER_BALL).build();
        Pokemon cherrim = helper.createDefaultPokemon(PixelmonSpecies.CHERRIM).ability(AbilityRegistry.FLOWER_GIFT).moves(AttackRegistry.GROWTH).build();
        Pokemon charizard = helper.createDefaultPokemon(PixelmonSpecies.CHARIZARD).ability(AbilityRegistry.SOLAR_POWER).moves(AttackRegistry.ROOST).build();
        Pokemon venusaur = helper.createDefaultPokemon(PixelmonSpecies.VENUSAUR).ability(AbilityRegistry.CHLOROPHYLL).moves(AttackRegistry.GROWTH).build();
        Pokemon toxicroak = helper.createDefaultPokemon(PixelmonSpecies.TOXICROAK).ability(AbilityRegistry.DRY_SKIN).moves(AttackRegistry.BULK_UP).build();
        TestParticipant defense = helper.createParticipant(castForm, cherrim, charizard, venusaur, toxicroak);
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            if (!defense.asWrapper().pokemon.getForm().is("sun")) {
                return TestResult.failure("Desolate Land should treat the weather as Sunny Day for any form's move or ability");
            }
            controller.takeFullTurn(() -> {
                attacker.attackSelf(1);
                defense.switchPokemon(castForm, cherrim);
            });
            if (!cherrim.getForm().is("sunshine")) {
                return TestResult.failure("Desolate Land should treat the weather as Sunny Day for any form's move or ability");
            }
            controller.takeFullTurn(() -> {
                attacker.attackSelf(1);
                defense.switchPokemon(cherrim, charizard);
            });
            if (defense.asWrapper().hasFullHealth()) {
                return TestResult.failure("Desolate Land should treat the weather as Sunny Day and so Charizard should be hurt by Solar Power");
            }
            int speed = defense.asWrapper(venusaur).getBattleStats().getStage(BattleStatsType.SPEED);
            controller.takeFullTurn(() -> {
                attacker.attackAutoTarget(2);
                defense.switchPokemon(charizard, venusaur);
            });
            if (2 * speed != defense.asWrapper(venusaur).getBattleStats().getStage(BattleStatsType.SPEED)) {
                return TestResult.failure("Desolate Land should treat the weather as Sunny Day and so Chlorophyll should be activated");
            }
            if (defense.asWrapper(venusaur).hasFullHealth()) {
                return TestResult.failure("Desolate Land should treat the weather as Sunny Day and so Slower Power's charge up turn should be skipped");
            }
            controller.takeFullTurn(() -> {
                attacker.attackAutoTarget(2);
                defense.switchPokemon(venusaur, toxicroak);
            });
            if (defense.asWrapper(toxicroak).hasFullHealth()) {
                return TestResult.failure("Desolate Land should treat the weather as Sunny Day and so Dry Skin should be activated");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDesolateLandWeatherFadesWhenSwitchedOut(BattleTestHelper helper) {
        Pokemon groudon = helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.HELPING_HAND).build();
        Pokemon hooh = helper.createDefaultPokemon(PixelmonSpecies.HOOH).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build();
        TestParticipant attacker = helper.createParticipant(groudon, hooh);
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            controller.takeFullTurn(() -> {
                defense.attackSelf(1);
                attacker.switchPokemon(groudon, hooh);
            });
            if (controller.globalStatusController.getWeather() instanceof Sunny) {
                return TestResult.failure("Desolate Land should fade when switched out");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDesolateLandWeatherNotFadeWhenSwitchedOutButOtherActive(BattleTestHelper helper) {
        Pokemon groudon = helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.HELPING_HAND).build();
        Pokemon hooh = helper.createDefaultPokemon(PixelmonSpecies.HOOH).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build();
        TestParticipant attacker = helper.createParticipant(groudon, hooh);
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.BULK_UP).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            block3: {
                block2: {
                    controller.takeFullTurn(() -> {
                        defense.attackSelf(1);
                        attacker.switchPokemon(groudon, hooh);
                    });
                    Weather patt10562$temp = controller.globalStatusController.getWeather();
                    if (!(patt10562$temp instanceof Sunny)) break block2;
                    Sunny sunny = (Sunny)patt10562$temp;
                    if (sunny.extreme) break block3;
                }
                return TestResult.failure("Desolate Land should not fade when switched out but other active");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDesolateLandWeatherFadesAfterSupressed(BattleTestHelper helper) {
        Pokemon groudon = helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.HELPING_HAND).build();
        TestParticipant attacker = helper.createParticipant(groudon);
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.GASTRO_ACID).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            controller.takeFullTurn(() -> {
                defense.attackAutoTarget(1);
                attacker.attackSelf(1);
            });
            if (controller.globalStatusController.getWeather() instanceof Sunny) {
                return TestResult.failure("Desolate Land should fade after supressed");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDesolateLandWeatherNotFadeAfterSupressedAndOtherStillActive(BattleTestHelper helper) {
        Pokemon groudon = helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.HELPING_HAND).build();
        TestParticipant attacker = helper.createParticipant(groudon);
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.GASTRO_ACID).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            block3: {
                block2: {
                    controller.takeFullTurn(() -> {
                        defense.attackAutoTarget(1);
                        attacker.attackSelf(1);
                    });
                    Weather patt12563$temp = controller.globalStatusController.getWeather();
                    if (!(patt12563$temp instanceof Sunny)) break block2;
                    Sunny sunny = (Sunny)patt12563$temp;
                    if (sunny.extreme) break block3;
                }
                return TestResult.failure("Desolate Land should not fade after supressed but other still active");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDesolateLandWeatherFadesAfterAbilityChange(BattleTestHelper helper) {
        Pokemon groudon = helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DESOLATE_LAND).moves(AttackRegistry.HELPING_HAND).build();
        TestParticipant attacker = helper.createParticipant(groudon);
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ENTRAINMENT).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            controller.takeFullTurn(() -> {
                defense.attackAutoTarget(1);
                attacker.attackSelf(1);
            });
            if (controller.globalStatusController.getWeather() instanceof Sunny) {
                return TestResult.failure("Desolate Land should fade after ability change");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDesolateLandWeatherFadesAfterRoar(BattleTestHelper helper) {
        Pokemon groudon = helper.createDefaultPokemon(PixelmonSpecies.GROUDON).heldItem(PixelmonItems.red_orb).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon wynaut = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant attacker = helper.createParticipant(groudon, wynaut);
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.ROAR).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            controller.takeFullTurn(() -> {
                defense.attackAutoTarget(1);
                attacker.attackSelf(1);
            });
            if (controller.globalStatusController.getWeather() instanceof Sunny) {
                return TestResult.failure("Desolate Land should fade after Roar");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDesolateLandWeatherCauseWaterTypeNaturalGiftFailure(BattleTestHelper helper) {
        Pokemon groudon = helper.createDefaultPokemon(PixelmonSpecies.GROUDON).heldItem(PixelmonItems.red_orb).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant attacker = helper.createParticipant(groudon);
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.NATURAL_GIFT).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            controller.takeFullTurn(() -> {
                defense.attackAutoTarget(1);
                attacker.attackSelf(1);
            });
            if (!attacker.asWrapper().hasFullHealth()) {
                return TestResult.failure("Desolate Land should cause Water-type Natural Gift to fail");
            }
            return TestResult.success();
        });
    }
}

