/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.MysteriousAirCurrent;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class DeltaStreamTests {
    @BattleTest
    public static CompletableFuture<TestResult> testDeltaStreamWeatherActivesOnSwitchIn(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.ROOST).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ABRA).ability(AbilityRegistry.MAGIC_GUARD).moves(AttackRegistry.TELEPORT).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            if (controller.globalStatusController.getWeather() instanceof MysteriousAirCurrent) {
                return TestResult.success();
            }
            return TestResult.failure("Delta Stream should activate on switch in");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDeltaStreamNegatesTheTypeWeaknessOfFlying(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TORNADUS).ability(AbilityRegistry.DELTA_STREAM).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.RECOVER).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.OWN_TEMPO).moves(AttackRegistry.THUNDER_SHOCK, AttackRegistry.POWDER_SNOW, AttackRegistry.POWER_GEM).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            for (int i = 1; i < 4; ++i) {
                attacker.attackSelf(1);
                defense.attackAutoTarget(i);
                if (attacker.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                    return TestResult.failure("Delta Stream should negate the type weakness of Flying");
                }
                if (attacker.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) == 0) continue;
                return TestResult.failure("Delta Stream should negate the type weakness of Flying");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotNegateTypeWeaknessOfOtherTypesEvenIfFlyingType(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).heldItem(PixelmonItems.weakness_policy).moves(AttackRegistry.RECOVER).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.OWN_TEMPO).moves(AttackRegistry.DRAGON_PULSE).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackAutoTarget(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            if (attacker.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Delta Stream should not negate the type weaknesses of any other type, even if the Pokemon is Flying-type");
            }
            if (attacker.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 2) {
                return TestResult.failure("Delta Stream should not negate the type weaknesses of any other type, even if the Pokemon is Flying-type");
            }
            if (attacker.asWrapper().getHeldItem() == PixelmonItems.weakness_policy) {
                return TestResult.failure("Delta Stream should not negate the type weakness of other types");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testStealthRockDamageNotReduced(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build(), helper.createDefaultPokemon(PixelmonSpecies.HOOH).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.STEALTH_ROCK).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackAutoTarget(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            controller.takeFullTurn(() -> {
                attacker.switchPokemon(attacker.asWrapper().pokemon, attacker.allPokemon[1].pokemon);
                defense.attackAutoTarget(1);
            });
            int targetHealth = Math.round((float)attacker.asWrapper().getMaxHealth() / 2.0f);
            int health = attacker.asWrapper().getHealth();
            if (health != targetHealth) {
                return TestResult.equal(health, targetHealth, "Delta Stream should not reduce the damage of Stealth Rock");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPreventsMovesAndAbilitiesFromChangingTheWeather(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ABRA).ability(AbilityRegistry.MAGIC_GUARD).moves(AttackRegistry.TELEPORT).build(), helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.DRIZZLE).moves(AttackRegistry.RAIN_DANCE).build(), helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.SUNNY_DAY).build(), helper.createDefaultPokemon(PixelmonSpecies.TYRANITAR).ability(AbilityRegistry.SAND_STREAM).moves(AttackRegistry.SANDSTORM).build(), helper.createDefaultPokemon(PixelmonSpecies.ABOMASNOW).ability(AbilityRegistry.SNOW_WARNING).moves(AttackRegistry.HAIL).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            for (int i = 1; i <= 4; ++i) {
                attacker.attackSelf(1);
                defense.switchPokemon(defense.asWrapper().pokemon, defense.allPokemon[i].pokemon);
                controller.takeFullTurn();
                if (!(controller.globalStatusController.getWeather() instanceof MysteriousAirCurrent)) {
                    return TestResult.failure("Delta Stream should prevent moves and abilities from changing the weather");
                }
                attacker.attackSelf(1);
                defense.attackAutoTarget(1);
                controller.takeFullTurn();
                if (controller.globalStatusController.getWeather() instanceof MysteriousAirCurrent) continue;
                return TestResult.failure("Delta Stream should prevent moves and abilities from changing the weather");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDeltaStreamFadesAfterSwitchOut(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.HELPING_HAND).build(), helper.createDefaultPokemon(PixelmonSpecies.HOOH).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.switchPokemon(attacker.asWrapper().pokemon, attacker.allPokemon[1].pokemon);
                defense.attackAutoTarget(1);
            });
            if (controller.globalStatusController.getWeather() instanceof MysteriousAirCurrent) {
                return TestResult.failure("Delta Stream should fade after switch out");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDeltaStreamNotFadesAfterSwitchOutWithOtherActive(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.HELPING_HAND).build(), helper.createDefaultPokemon(PixelmonSpecies.HOOH).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ROOST).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.BULK_UP).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.switchPokemon(attacker.asWrapper().pokemon, attacker.allPokemon[1].pokemon);
                defense.attackAutoTarget(1);
            });
            if (!(controller.globalStatusController.getWeather() instanceof MysteriousAirCurrent)) {
                return TestResult.failure("Delta Stream should not fade after switch out with other active");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDeltaStreamFadesWhenSuppressed(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.GASTRO_ACID).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            if (controller.globalStatusController.getWeather() instanceof MysteriousAirCurrent) {
                return TestResult.failure("Delta Stream should fake if the ability is suppressed and there is not another active");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDeltaStreamDoesNotFadeWhenSuppressedAndAnotherActive(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.GASTRO_ACID).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            if (!(controller.globalStatusController.getWeather() instanceof MysteriousAirCurrent)) {
                return TestResult.failure("Delta Stream should not fade if the ability is suppressed and there is another active");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDeltaStreamFadesWhenAbilityChangedAndNoOtherActive(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.HELPING_HAND).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LUGIA).ability(AbilityRegistry.PRESSURE).moves(AttackRegistry.ENTRAINMENT).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            if (controller.globalStatusController.getWeather() instanceof MysteriousAirCurrent) {
                return TestResult.failure("Delta Stream should fade if the ability is changed and there is not another active");
            }
            return TestResult.success();
        });
    }
}

