/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class DazzlingTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBlocksMovesWithPositivePriority(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SABLEYE).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.TAUNT).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRUXISH).ability(AbilityRegistry.DAZZLING).moves(AttackRegistry.SWORDS_DANCE).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackAutoTarget(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            if (defense.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == 2) {
                return TestResult.success();
            }
            return TestResult.failure("Dazzling should block moves with positive priority");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotBlockMovesThatTargetAllPokemonWithSomeExceptions(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.BRUXISH).ability(AbilityRegistry.DAZZLING).moves(AttackRegistry.SWORDS_DANCE, AttackRegistry.SLEEP_TALK).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MEW).ability(AbilityRegistry.PRANKSTER).moves(AttackRegistry.PERISH_SONG, AttackRegistry.HAZE).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackAutoTarget(1);
            defense.attackAutoTarget(1);
            controller.takeFullTurn();
            attacker.attackAutoTarget(2);
            defense.attackAutoTarget(2);
            controller.takeFullTurn();
            if (attacker.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == 0 && !attacker.asWrapper().hasStatus(StatusType.Perish)) {
                return TestResult.success();
            }
            return TestResult.failure("Dazzling should not block moves that target all Pokemon except Perish Song, Rototiller, and Flower Shield");
        });
    }
}

