/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;
import net.minecraft.world.item.Item;

@BattleTestClass
public class DancerTests {
    @BattleTest
    public static CompletableFuture<TestResult> testOnlyCopiesDanceMovesUsedByOtherPokemon(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ORICORIO).ability(AbilityRegistry.DANCER).moves(AttackRegistry.SWORDS_DANCE).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ORICORIO).ability(AbilityRegistry.DANCER).moves(AttackRegistry.HOWL).build());
        return helper.setupSingleBattleBuilder(attacker, defense).forceChance().start().thenApply(controller -> {
            attacker.attackSelf(1);
            defense.attackSelf(1);
            controller.takeFullTurn();
            if (attacker.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == 2 && defense.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == 3) {
                return TestResult.success();
            }
            return TestResult.failure("Dancer should only copy dance moves used by other Pokemon");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testActivatesInOrderOfLowestToHighestRawSpeed(BattleTestHelper helper) {
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).level(98).ability(AbilityRegistry.DANCER).heldItem(PixelmonItems.focus_sash).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).level(99).ability(AbilityRegistry.DANCER).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon defense1 = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.WONDER_GUARD).moves(AttackRegistry.FIERY_DANCE).build();
        Pokemon defense2 = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.DANCER).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        TestParticipant defense = helper.createParticipant(2, defense1, defense2);
        return helper.setupDoubleBattleBuilder(attacker, defense).forceChance().start().thenApply(controller -> {
            ((PixelmonWrapper)attacker.controlledPokemon.get(1)).getBattleStats().setStage(BattleStatsType.SPEED, 6);
            attacker.attackAutoTarget(attacker1, 1);
            attacker.attackAutoTarget(attacker2, 1);
            defense.attackTarget(defense1, 1, attacker1);
            defense.attackAutoTarget(defense2, 1);
            controller.takeFullTurn();
            if (defense1.isFainted() && defense2.isFainted()) {
                return TestResult.success();
            }
            return TestResult.failure("Dancer activate in order of lowest to highest raw speed");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testActivatesInOrderOfLowestToHighestRawSpeedInsideTrickRoom(BattleTestHelper helper) {
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).level(98).ability(AbilityRegistry.DANCER).heldItem(PixelmonItems.focus_sash).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).level(99).ability(AbilityRegistry.DANCER).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon defense1 = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.WONDER_GUARD).moves(AttackRegistry.FIERY_DANCE, AttackRegistry.WONDER_ROOM).build();
        Pokemon defense2 = helper.createDefaultPokemon(PixelmonSpecies.SHEDINJA).ability(AbilityRegistry.DANCER).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        TestParticipant defense = helper.createParticipant(2, defense1, defense2);
        return helper.setupDoubleBattleBuilder(attacker, defense).forceChance().start().thenApply(controller -> {
            ((PixelmonWrapper)attacker.controlledPokemon.get(1)).getBattleStats().setStage(BattleStatsType.SPEED, 6);
            attacker.attackAutoTarget(attacker1, 1);
            attacker.attackAutoTarget(attacker2, 1);
            defense.attackAutoTarget(defense1, 2);
            defense.attackAutoTarget(defense2, 1);
            controller.takeFullTurn();
            attacker.attackAutoTarget(attacker1, 1);
            attacker.attackAutoTarget(attacker2, 1);
            defense.attackTarget(defense1, 1, attacker1);
            defense.attackAutoTarget(defense2, 1);
            controller.takeFullTurn();
            if (defense1.isFainted() && defense2.isFainted()) {
                return TestResult.success();
            }
            return TestResult.failure("Dancer activate in order of lowest to highest raw speed in Trick Room");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDoesNotCopyProtectBlockedMoves(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ORICORIO).ability(AbilityRegistry.DANCER).moves(AttackRegistry.PROTECT).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.DANCER).moves(AttackRegistry.FIERY_DANCE).build());
        return helper.setupSingleBattleBuilder(attacker, defense).forceChance().start().thenApply(controller -> {
            attacker.attackOpponent(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            if (defense.asWrapper().hasFullHealth()) {
                return TestResult.success();
            }
            return TestResult.failure("Dancer should not copy moves blocked by Protect");
        });
    }

    public static CompletableFuture<TestResult> testDoesNotCopyTeeterDanceWhenTargetsAreConfused(BattleTestHelper helper) {
        Pokemon attacker1 = helper.createDefaultPokemon(PixelmonSpecies.ORICORIO).ability(AbilityRegistry.DANCER).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.PROTECT).build();
        Pokemon attacker2 = helper.createDefaultPokemon(PixelmonSpecies.SLOWBRO).ability(AbilityRegistry.OWN_TEMPO).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon defense1 = helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.DANCER).heldItem(PixelmonItems.persim_berry).moves(AttackRegistry.SLEEP_TALK, AttackRegistry.TEETER_DANCE).build();
        Pokemon defense2 = helper.createDefaultPokemon(PixelmonSpecies.SLOWKING).ability(AbilityRegistry.OWN_TEMPO).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant attacker = helper.createParticipant(2, attacker1, attacker2);
        TestParticipant defense = helper.createParticipant(2, defense1, defense2);
        return helper.setupDoubleBattleBuilder(attacker, defense).forceChance().start().thenApply(controller -> {
            attacker.attackAutoTarget(attacker1, 2);
            attacker.attackAutoTarget(attacker2, 1);
            defense.attackAutoTarget(defense1, 2);
            defense.attackAutoTarget(defense2, 1);
            controller.takeFullTurn();
            if (!defense1.getHeldItem().m_150930_((Item)PixelmonItems.persim_berry)) {
                return TestResult.failure("The Persim berry should not be consumed as Dancer did not activate");
            }
            attacker.attackAutoTarget(attacker1, 1);
            attacker.attackAutoTarget(attacker2, 1);
            defense.attackAutoTarget(defense1, 2);
            defense.attackAutoTarget(defense2, 1);
            controller.takeFullTurn();
            if (defense1.getHeldItem().m_150930_((Item)PixelmonItems.persim_berry)) {
                return TestResult.failure("The persim berry should be consumed as Dancer activated");
            }
            return TestResult.success();
        });
    }
}

