/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class DampTests {
    @BattleTest
    public static CompletableFuture<TestResult> testPreventsSelfDestructMoves(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.POLITOED).ability(AbilityRegistry.DAMP).moves(AttackRegistry.CALM_MIND).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.STATIC).moves(AttackRegistry.EXPLOSION).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackOpponent(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            if (attacker.asWrapper().hasFullHealth() && defense.asWrapper().hasFullHealth()) {
                return TestResult.success();
            }
            return TestResult.failure("Damp did not prevent explosion from activating");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testPreventsAftermath(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.POLIWRATH).ability(AbilityRegistry.DAMP).moves(AttackRegistry.CLOSE_COMBAT).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARON).ability(AbilityRegistry.AFTERMATH).moves(AttackRegistry.LEER).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackOpponent(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            if (attacker.asWrapper().hasFullHealth() && defense.controlledPokemon.isEmpty() && defense.allPokemon[0].isFainted()) {
                return TestResult.success();
            }
            return TestResult.failure("Damp did not prevent aftermath from activating");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testMoldBreakerSupresses(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.POLITOED).ability(AbilityRegistry.DAMP).moves(AttackRegistry.CALM_MIND).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ELECTRODE).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.EXPLOSION).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackOpponent(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            if (!attacker.asWrapper().hasFullHealth() && defense.controlledPokemon.isEmpty() && defense.allPokemon[0].isFainted()) {
                return TestResult.success();
            }
            return TestResult.failure("Damp still prevented explosion from activating even with mold breaker on the field!");
        });
    }
}

