/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.Disable;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class CursedBodyTests {
    @BattleTest
    public static CompletableFuture<TestResult> testCursedBodyDisablesDamagingZMoveNotBase(BattleTestHelper helper) {
        TestParticipant gengar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENGAR).ability(AbilityRegistry.CURSED_BODY).heldItem(PixelmonItems.focus_sash).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant komoo = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KOMMOO).heldItem(PixelmonItems.kommonium_z).moves(AttackRegistry.CLANGING_SCALES, AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(gengar, komoo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                gengar.attackOpponent(1);
                komoo.attackOpponent(1);
                komoo.useZMove();
            });
            if (!komoo.asWrapper().hasStatus(StatusType.Disable)) {
                return TestResult.failure("Cursed Body should disable the Pokemon that hit the Pok\u00e9mon");
            }
            Disable status = (Disable)komoo.asWrapper().getStatus(StatusType.Disable);
            if (status.getDisabledMove().isAttack(AttackRegistry.CLANGING_SCALES)) {
                return TestResult.failure("Cursed Body should not disable the base move of the Z-Move");
            }
            if (status.getDisabledMove().isAttack(AttackRegistry.CLANGOROUS_SOULBLAZE)) {
                return TestResult.success();
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCursedBodyDoesNotDisableHitsToSubstitute(BattleTestHelper helper) {
        TestParticipant gengar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENGAR).ability(AbilityRegistry.CURSED_BODY).moves(AttackRegistry.SUBSTITUTE).build());
        TestParticipant komoo = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KOMMOO).moves(AttackRegistry.DRAGON_CLAW).build());
        return helper.setupSingleBattleBuilder(gengar, komoo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                gengar.attackSelf(1);
                komoo.attackOpponent(1);
            });
            if (komoo.asWrapper().hasStatus(StatusType.Disable)) {
                return TestResult.failure("Cursed Body should not disable moves hitting a substitute.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCursedBodyDoesDisableHitsBypassingSubstitute(BattleTestHelper helper) {
        TestParticipant gengar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENGAR).ability(AbilityRegistry.CURSED_BODY).moves(AttackRegistry.SUBSTITUTE).build());
        TestParticipant golbat = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLBAT).ability(AbilityRegistry.INFILTRATOR).moves(AttackRegistry.DRILL_PECK).build());
        return helper.setupSingleBattleBuilder(gengar, golbat).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                gengar.attackSelf(1);
                golbat.attackOpponent(1);
            });
            if (!gengar.asWrapper().hasStatus(StatusType.Substitute)) {
                return TestResult.failure("Golbat hit the substitute instead of Gengar.");
            }
            if (!golbat.asWrapper().hasStatus(StatusType.Disable)) {
                return TestResult.failure("Cursed Body should disable moves bypassing a substitute.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCursedBodyDoesNotInterruptMultiHitMoves(BattleTestHelper helper) {
        TestParticipant gengar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GENGAR).ability(AbilityRegistry.CURSED_BODY).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant cloyster = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLOYSTER).ability(AbilityRegistry.SKILL_LINK).moves(AttackRegistry.ROCK_BLAST).build());
        return helper.setupSingleBattleBuilder(gengar, cloyster).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                gengar.attackSelf(1);
                cloyster.attackOpponent(1);
            });
            if (!cloyster.asWrapper().hasStatus(StatusType.Disable)) {
                return TestResult.failure("Cursed Body should disable multihit moves.");
            }
            if (gengar.asWrapper().getHealthDeficit() < 50) {
                return TestResult.failure("Cursed Body should not interrupt multi-hit moves.");
            }
            return TestResult.success();
        });
    }
}

