/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ContraryTests {
    @BattleTest
    public static CompletableFuture<TestResult> testRelativeStatChangesGetInverted(BattleTestHelper helper) {
        TestParticipant spinda = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SPINDA).ability(AbilityRegistry.CONTRARY).moves(AttackRegistry.SUPERPOWER).build());
        TestParticipant dragonite = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DRAGONITE).ability(AbilityRegistry.MULTISCALE).moves(AttackRegistry.DRAGON_DANCE).build());
        return helper.createSingleBattle(spinda, dragonite).thenApply(controller -> {
            spinda.attackOpponent(1);
            dragonite.attackOpponent(1);
            controller.takeFullTurn();
            if (spinda.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 1) {
                return TestResult.failure("Contrary should invert relative stat changes");
            }
            if (spinda.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != 1) {
                return TestResult.failure("Contrary should invert relative stat changes");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testAbsoluteChangesNotInverted(BattleTestHelper helper) {
        TestParticipant serperior = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SERPERIOR).ability(AbilityRegistry.CONTRARY).moves(AttackRegistry.LEECH_SEED).build());
        TestParticipant growlithe = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROWLITHE).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.TOPSY_TURVY).build());
        return helper.createSingleBattle(serperior, growlithe).thenApply(controller -> {
            serperior.attackOpponent(1);
            growlithe.attackOpponent(1);
            controller.takeFullTurn();
            if (serperior.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Contrary should not invert absolute stat changes");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testContraryInvertsBellyDrumMaximizingAttack(BattleTestHelper helper) {
        TestParticipant spinda = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SPINDA).ability(AbilityRegistry.CONTRARY).moves(AttackRegistry.BELLY_DRUM).build());
        TestParticipant dragonite = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DRAGONITE).moves(AttackRegistry.DRAGON_DANCE).build());
        return helper.createSingleBattle(spinda, dragonite).thenApply(controller -> {
            spinda.attackOpponent(1);
            dragonite.attackOpponent(1);
            controller.takeFullTurn();
            if (spinda.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -6) {
                return TestResult.failure("Contrary should invert Belly Drum's attack maximization");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testContrarySuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant spinda = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SPINDA).ability(AbilityRegistry.CONTRARY).moves(AttackRegistry.TACKLE).build());
        TestParticipant dragonite = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DRAGONITE).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.GROWL).build());
        return helper.createSingleBattle(spinda, dragonite).thenApply(controller -> {
            spinda.attackOpponent(1);
            dragonite.attackOpponent(1);
            controller.takeFullTurn();
            if (spinda.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Contrary should be suppressed by mold breaker");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> contraryDoesNotReverseZPowerEffects(BattleTestHelper helper) {
        TestParticipant simple = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHUCKLE).ability(AbilityRegistry.CONTRARY).moves(AttackRegistry.GROWTH).heldItem(PixelmonItems.normalium_z).build());
        TestParticipant sunny = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NINETALES).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.ENDURE).build());
        return helper.setupDoubleBattleBuilder(simple, sunny).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                simple.attackSelf(1);
                simple.useZMove();
                sunny.attackSelf(1);
            });
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -2) {
                return TestResult.failure("Contrary should reverse normal effects for status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != -1) {
                return TestResult.failure("Contrary should not reverse Z-Power effects for status Z-moves");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> contraryReversesClangorousSoulblaze(BattleTestHelper helper) {
        TestParticipant simple = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KOMMOO).ability(AbilityRegistry.CONTRARY).moves(AttackRegistry.CLANGING_SCALES).heldItem(PixelmonItems.kommonium_z).build());
        TestParticipant sunny = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NINETALES).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.ENDURE).build());
        return helper.setupDoubleBattleBuilder(simple, sunny).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                simple.attackOpponent(1);
                simple.useZMove();
                sunny.attackSelf(1);
            });
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != -1) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != -1) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_DEFENSE) != -1) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != -1) {
                return TestResult.failure("Simple should not boost secondary Z-effects.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> contraryReversesExtremeEvoboost(BattleTestHelper helper) {
        TestParticipant simple = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.EEVEE).ability(AbilityRegistry.CONTRARY).moves(AttackRegistry.LAST_RESORT).heldItem(PixelmonItems.eevium_z).build());
        TestParticipant sunny = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.NINETALES).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.ENDURE).build());
        return helper.setupDoubleBattleBuilder(simple, sunny).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                simple.attackSelf(1);
                simple.useZMove();
                sunny.attackSelf(1);
            });
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -2) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != -2) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != -2) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_DEFENSE) != -2) {
                return TestResult.failure("Simple should boost base effects of status Z-moves");
            }
            if (simple.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != -2) {
                return TestResult.failure("Simple should not boost secondary Z-effects.");
            }
            return TestResult.success();
        });
    }
}

