/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ComatoseTests {
    @BattleTest
    public static CompletableFuture<TestResult> testsTheUserBecomesImmuneToStatusConditions(BattleTestHelper helper) {
        TestParticipant komala = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KOMALA).ability(AbilityRegistry.COMATOSE).moves(AttackRegistry.SHADOW_CLAW).build());
        TestParticipant smeargle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.SPORE, AttackRegistry.GLARE, AttackRegistry.WILL_O_WISP, AttackRegistry.TOXIC).build());
        return helper.createSingleBattle(komala, smeargle).thenApply(controller -> {
            for (int i = 1; i <= 4; ++i) {
                komala.attackOpponent(1);
                smeargle.attackOpponent(i);
                controller.takeFullTurn();
                if (komala.asWrapper().getStatuses().isEmpty()) continue;
                return TestResult.failure("Comatose should make the user immune to status conditions");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testsTheUserBecomesImmuneToStatusConditionsNotSupressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant komala = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KOMALA).ability(AbilityRegistry.COMATOSE).moves(AttackRegistry.SHADOW_CLAW).build());
        TestParticipant smeargle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.SPORE, AttackRegistry.GLARE, AttackRegistry.WILL_O_WISP, AttackRegistry.TOXIC).build());
        return helper.createSingleBattle(komala, smeargle).thenApply(controller -> {
            for (int i = 1; i <= 4; ++i) {
                komala.attackOpponent(1);
                smeargle.attackOpponent(i);
                controller.takeFullTurn();
                if (komala.asWrapper().getStatuses().isEmpty()) continue;
                return TestResult.failure("Comatose should make the user immune to status conditions and not be suppressed by mold breaker");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testRestFailsWithComatose(BattleTestHelper helper) {
        TestParticipant komala = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KOMALA).ability(AbilityRegistry.COMATOSE).moves(AttackRegistry.REST).build());
        TestParticipant smeargle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.TECHNICIAN).moves(AttackRegistry.AQUA_JET).build());
        return helper.createSingleBattle(komala, smeargle).thenApply(controller -> {
            komala.attackSelf(1);
            smeargle.attackOpponent(1);
            controller.takeFullTurn();
            if (komala.asWrapper().getHealthPercent() == 100.0f) {
                return TestResult.failure("Comatose should cause rest to fail");
            }
            if (!komala.asWrapper().getStatuses().isEmpty()) {
                return TestResult.failure("Comatose should cause rest to fail");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testComatoseAllowsSleepAndSnoreCorrectly(BattleTestHelper helper) {
        TestParticipant komala = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KOMALA).heldItem(PixelmonItems.normalium_z).ability(AbilityRegistry.COMATOSE).moves(AttackRegistry.SNORE, AttackRegistry.SLEEP_TALK, AttackRegistry.DRAGON_RAGE).build());
        TestParticipant smeargle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).moves(AttackRegistry.LUCKY_CHANT).build());
        return helper.createSingleBattle(komala, smeargle).thenApply(controller -> {
            komala.attackOpponent(1);
            smeargle.attackSelf(1);
            controller.takeFullTurn();
            if (smeargle.asWrapper().hasFullHealth()) {
                return TestResult.failure("Comatose should allow the use of Snore as if the user were asleep");
            }
            int deficit = smeargle.asWrapper().getHealthDeficit();
            komala.attackOpponent(2);
            smeargle.attackSelf(1);
            controller.takeFullTurn();
            if (smeargle.asWrapper().getHealthDeficit() == deficit) {
                return TestResult.failure("Comatose should allow the use of Sleep Talk as if the user were asleep");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testDreamEaterThinksUserSleeps(BattleTestHelper helper) {
        TestParticipant komala = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KOMALA).ability(AbilityRegistry.COMATOSE).moves(AttackRegistry.SHADOW_CLAW).build());
        TestParticipant smeargle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.TECHNICIAN).moves(AttackRegistry.DREAM_EATER).build());
        return helper.createSingleBattle(komala, smeargle).thenApply(controller -> {
            komala.attackOpponent(1);
            smeargle.attackOpponent(1);
            controller.takeFullTurn();
            if (komala.asWrapper().hasFullHealth()) {
                return TestResult.failure("Comatose should allow damage from dream eater");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testWakeUpSlapAndHexDoublePower(BattleTestHelper helper) {
        TestParticipant komala = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KOMALA).ability(AbilityRegistry.COMATOSE).heldItem(PixelmonItems.ring_target).moves(AttackRegistry.ENDURE).build());
        TestParticipant smeargle = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SMEARGLE).ability(AbilityRegistry.TECHNICIAN).moves(AttackRegistry.HEX, AttackRegistry.WAKE_UP_SLAP).build());
        return helper.createSingleBattle(komala, smeargle).thenApply(controller -> {
            int hexPower = AttackRegistry.HEX.getValueUnsafe().ofMutable().modifyMoveStats(smeargle.asWrapper(), komala.asWrapper(), smeargle.asWrapper().getBattleAbility(), komala.asWrapper().getBattleAbility(), AttackRegistry.HEX.getValueUnsafe().getBasePower())[0];
            if (hexPower != AttackRegistry.HEX.getValueUnsafe().getBasePower() * 2) {
                return TestResult.failure("Comatose should double the power of Hex");
            }
            int wakeUpSlap = AttackRegistry.WAKE_UP_SLAP.getValueUnsafe().ofMutable().modifyMoveStats(smeargle.asWrapper(), komala.asWrapper(), smeargle.asWrapper().getBattleAbility(), komala.asWrapper().getBattleAbility(), AttackRegistry.WAKE_UP_SLAP.getValueUnsafe().getBasePower())[0];
            if (wakeUpSlap != AttackRegistry.WAKE_UP_SLAP.getValueUnsafe().getBasePower() * 2) {
                return TestResult.failure("Comatose should double the power of Wake Up Slap");
            }
            return TestResult.success();
        });
    }
}

