/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ColorChangeTests {
    @BattleTest
    public static CompletableFuture<TestResult> testTheUserTypeChangesWhenStruck(BattleTestHelper helper) {
        TestParticipant kelceon = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KECLEON).ability(AbilityRegistry.COLOR_CHANGE).moves(AttackRegistry.RECOVER).build());
        TestParticipant paras = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PARAS).ability(AbilityRegistry.DAMP).moves(AttackRegistry.ABSORB).build());
        return helper.createSingleBattle(kelceon, paras).thenApply(controller -> {
            kelceon.attackOpponent(1);
            paras.attackOpponent(1);
            controller.takeFullTurn();
            if (!kelceon.asWrapper().type.contains(Element.GRASS)) {
                return TestResult.failure("Color change should change the user's type when struck by a move");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTypeDoesNotChangeWhenSubstituteHit(BattleTestHelper helper) {
        TestParticipant kelceon = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KECLEON).ability(AbilityRegistry.COLOR_CHANGE).moves(AttackRegistry.SUBSTITUTE).build());
        TestParticipant machamp = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MACHAMP).ability(AbilityRegistry.PURE_POWER).heldItem(PixelmonItems.lagging_tail).moves(AttackRegistry.CLOSE_COMBAT).build());
        return helper.createSingleBattle(kelceon, machamp).thenApply(controller -> {
            kelceon.attackOpponent(1);
            machamp.attackOpponent(1);
            controller.takeFullTurn();
            if (kelceon.asWrapper().type.contains(Element.FIGHTING)) {
                return TestResult.failure("Color change should not change the user's type if it had a Substitute when hit");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testTypeChangesWhenSubstituteBypassed(BattleTestHelper helper) {
        TestParticipant kelceon = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KECLEON).ability(AbilityRegistry.COLOR_CHANGE).moves(AttackRegistry.SUBSTITUTE).build());
        TestParticipant zubat = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ZUBAT).ability(AbilityRegistry.INFILTRATOR).heldItem(PixelmonItems.lagging_tail).moves(AttackRegistry.DRILL_PECK).build());
        return helper.createSingleBattle(kelceon, zubat).thenApply(controller -> {
            kelceon.attackSelf(1);
            zubat.attackOpponent(1);
            controller.takeFullTurn();
            if (!kelceon.asWrapper().type.contains(Element.FLYING)) {
                return TestResult.failure("Color change should change the user's type if it had a Substitute bypassed");
            }
            return TestResult.success();
        });
    }
}

