/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.MysteriousAirCurrent;
import com.pixelmonmod.pixelmon.battles.status.Rainy;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import com.pixelmonmod.pixelmon.battles.status.Sunny;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class CloudNineTests {
    @BattleTest
    public static CompletableFuture<TestResult> testCloudNinePreventsWeatherEffects(BattleTestHelper helper) {
        TestParticipant golduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLDUCK).ability(AbilityRegistry.CLOUD_NINE).moves(AttackRegistry.SUNNY_DAY).build());
        TestParticipant cherrim = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CHERRIM).ability(AbilityRegistry.FLOWER_GIFT).heldItem(PixelmonItems.lagging_tail).moves(AttackRegistry.SOLAR_BEAM).build());
        return helper.setupSingleBattleBuilder(golduck, cherrim).forceChance().start().thenApply(controller -> {
            golduck.attackSelf(1);
            cherrim.attackOpponent(1);
            controller.takeFullTurn();
            if (golduck.asWrapper().getHealthPercent() != 100.0f) {
                return TestResult.failure("Cloud Nine should treat the weather as none for the purposes moves");
            }
            if (!controller.globalStatusController.hasStatus(StatusType.Sunny)) {
                return TestResult.failure("Cloud Nine should not remove the weather, just suppress the effects");
            }
            if (controller.globalStatusController.getWeather() != null) {
                return TestResult.failure("Cloud Nine should treat the weather as none.");
            }
            if (!cherrim.asWrapper().getForm().isForm("overcast")) {
                return TestResult.failure("Cloud Nine should treat the weather as none for the purposes of forms and abilities");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkCloudNineSunNegatesFireAndWaterAttacks(BattleTestHelper helper) {
        TestParticipant groudon = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DROUGHT).moves(AttackRegistry.REST).build());
        TestParticipant golduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLDUCK).ability(AbilityRegistry.CLOUD_NINE).moves(AttackRegistry.CALM_MIND).build());
        return helper.setupSingleBattleBuilder(groudon, golduck).forceChance().start().thenApply(controller -> {
            groudon.attackSelf(1);
            golduck.attackSelf(1);
            controller.takeFullTurn();
            int modifiedFirePower = AttackRegistry.FIRE_PLEDGE.getValueUnsafe().ofMutable().modifyMoveStats(groudon.asWrapper(), golduck.asWrapper(), groudon.asWrapper().getBattleAbility(), golduck.asWrapper().getBattleAbility(), AttackRegistry.FIRE_PLEDGE.getValueUnsafe().getBasePower())[0];
            if (modifiedFirePower != AttackRegistry.FIRE_PLEDGE.getValueUnsafe().getBasePower()) {
                return TestResult.failure("Cloud Nine should negate the effects of Sun on Fire-type attacks");
            }
            int modifiedWaterPower = AttackRegistry.WATER_PLEDGE.getValueUnsafe().ofMutable().modifyMoveStats(golduck.asWrapper(), groudon.asWrapper(), golduck.asWrapper().getBattleAbility(), groudon.asWrapper().getBattleAbility(), AttackRegistry.WATER_PLEDGE.getValueUnsafe().getBasePower())[0];
            if (modifiedWaterPower != AttackRegistry.WATER_PLEDGE.getValueUnsafe().getBasePower()) {
                return TestResult.failure("Cloud Nine should negate the effects of Sun on Water-type attacks");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkCloudNineRainNegatesFireAndWaterAttacks(BattleTestHelper helper) {
        TestParticipant kyogre = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.DRIZZLE).moves(AttackRegistry.REST).build());
        TestParticipant golduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLDUCK).ability(AbilityRegistry.CLOUD_NINE).moves(AttackRegistry.CALM_MIND).build());
        return helper.setupSingleBattleBuilder(kyogre, golduck).forceChance().start().thenApply(controller -> {
            kyogre.attackSelf(1);
            golduck.attackSelf(1);
            controller.takeFullTurn();
            int modifiedFirePower = AttackRegistry.FIRE_PLEDGE.getValueUnsafe().ofMutable().modifyMoveStats(kyogre.asWrapper(), golduck.asWrapper(), kyogre.asWrapper().getBattleAbility(), golduck.asWrapper().getBattleAbility(), AttackRegistry.FIRE_PLEDGE.getValueUnsafe().getBasePower())[0];
            if (modifiedFirePower != AttackRegistry.FIRE_PLEDGE.getValueUnsafe().getBasePower()) {
                return TestResult.failure("Cloud Nine should negate the effects of Rain on Fire-type attacks");
            }
            int modifiedWaterPower = AttackRegistry.WATER_PLEDGE.getValueUnsafe().ofMutable().modifyMoveStats(golduck.asWrapper(), kyogre.asWrapper(), golduck.asWrapper().getBattleAbility(), kyogre.asWrapper().getBattleAbility(), AttackRegistry.WATER_PLEDGE.getValueUnsafe().getBasePower())[0];
            if (modifiedWaterPower != AttackRegistry.WATER_PLEDGE.getValueUnsafe().getBasePower()) {
                return TestResult.failure("Cloud Nine should negate the effects of Rain on Water-type attacks");
            }
            int modifiedThunderAccuracy = AttackRegistry.THUNDER.getValueUnsafe().ofMutable().modifyMoveStats(kyogre.asWrapper(), golduck.asWrapper(), kyogre.asWrapper().getBattleAbility(), golduck.asWrapper().getBattleAbility(), AttackRegistry.THUNDER.getValueUnsafe().getBasePower())[1];
            if (modifiedThunderAccuracy < 0) {
                return TestResult.failure("Cloud Nine should negate the auto-hit effects of Rain on Thunder");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkCloudNineStopsSandStormDamage(BattleTestHelper helper) {
        TestParticipant tyranitar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TYRANITAR).ability(AbilityRegistry.SAND_STREAM).moves(AttackRegistry.DRAGON_DANCE).build());
        TestParticipant golduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLDUCK).ability(AbilityRegistry.CLOUD_NINE).moves(AttackRegistry.CALM_MIND).build());
        return helper.setupSingleBattleBuilder(tyranitar, golduck).forceChance().start().thenApply(controller -> {
            tyranitar.attackSelf(1);
            golduck.attackSelf(1);
            controller.takeFullTurn();
            if (!controller.globalStatusController.hasStatus(StatusType.Sandstorm)) {
                return TestResult.failure("Cloud Nine should not block adding the weather, just suppress the effects");
            }
            if (!golduck.asWrapper().hasFullHealth()) {
                return TestResult.failure("Cloud Nine should negate the damage-dealing effects of Sandstorm");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkCloudNineStopsSandStormRockSpDefBoost(BattleTestHelper helper) {
        TestParticipant tyranitar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TYRANITAR).ability(AbilityRegistry.SAND_STREAM).moves(AttackRegistry.LUCKY_CHANT).build());
        TestParticipant golduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLDUCK).ability(AbilityRegistry.CLOUD_NINE).heldItem(PixelmonItems.lagging_tail).moves(AttackRegistry.WATER_GUN).build());
        return helper.setupSingleBattleBuilder(tyranitar, golduck).forceChance().start().thenApply(controller -> {
            tyranitar.attackSelf(1);
            golduck.attackOpponent(1);
            controller.takeFullTurn();
            if (!helper.inRange(tyranitar.asWrapper().getHealthDeficit(), 84, 102)) {
                return TestResult.failure("Cloud Nine should negate the SpDef boosting effects of Sandstorm on Rock-types");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkCloudNineStopsHailDamage(BattleTestHelper helper) {
        TestParticipant abomasnow = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ABOMASNOW).ability(AbilityRegistry.SOUNDPROOF).moves(AttackRegistry.HAIL).build());
        TestParticipant golduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLDUCK).ability(AbilityRegistry.CLOUD_NINE).moves(AttackRegistry.CALM_MIND).build());
        return helper.setupSingleBattleBuilder(abomasnow, golduck).forceChance().start().thenApply(controller -> {
            abomasnow.attackOpponent(1);
            golduck.attackSelf(1);
            controller.takeFullTurn();
            if (!controller.globalStatusController.hasStatus(StatusType.Hail)) {
                return TestResult.failure("Cloud Nine should not prevent weather from starting, only their effects.");
            }
            if (!golduck.asWrapper().hasFullHealth()) {
                return TestResult.failure("Cloud Nine should negate the damage-dealing effects of Hail");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkCloudNineStopsSnowIceTypeDefBoost(BattleTestHelper helper) {
        TestParticipant abomasnow = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ABOMASNOW).ability(AbilityRegistry.SOUNDPROOF).moves(AttackRegistry.SNOWSCAPE, AttackRegistry.LUCKY_CHANT).build());
        TestParticipant golduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLDUCK).ability(AbilityRegistry.CLOUD_NINE).moves(AttackRegistry.WATERFALL, AttackRegistry.SLEEP_TALK).heldItem(PixelmonItems.lagging_tail).build());
        return helper.setupSingleBattleBuilder(abomasnow, golduck).forceChance().start().thenApply(controller -> {
            abomasnow.attackOpponent(1);
            golduck.attackOpponent(2);
            controller.takeFullTurn();
            abomasnow.attackOpponent(2);
            golduck.attackOpponent(1);
            controller.takeFullTurn();
            if (!controller.globalStatusController.hasStatus(StatusType.Snow)) {
                return TestResult.failure("Cloud Nine should not prevent weather from starting, only their effects.");
            }
            if (!helper.inRange(abomasnow.asWrapper().getHealthDeficit(), 46, 55)) {
                return TestResult.failure("Cloud Nine should negate the Def boosting effects of Snow on Ice-types.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkCloudNineDoesNotStopDesolateLand(BattleTestHelper helper) {
        TestParticipant groudon = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GROUDON).ability(AbilityRegistry.DROUGHT).heldItem(PixelmonItems.red_orb).moves(AttackRegistry.SUNNY_DAY).build());
        TestParticipant golduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLDUCK).ability(AbilityRegistry.CLOUD_NINE).moves(AttackRegistry.RAIN_DANCE).build());
        return helper.setupSingleBattleBuilder(groudon, golduck).forceChance().start().thenApply(controller -> {
            groudon.attackOpponent(1);
            golduck.attackOpponent(1);
            controller.takeFullTurn();
            if (!(controller.globalStatusController.getWeather() instanceof Sunny) || !controller.globalStatusController.getWeather().extreme) {
                return TestResult.failure("Cloud Nine should not negate Desolate Land's ability to prevent other weathers from activating");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkCloudNineDoesNotStopPrimordealSea(BattleTestHelper helper) {
        TestParticipant kyogre = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.KYOGRE).ability(AbilityRegistry.DRIZZLE).heldItem(PixelmonItems.blue_orb).moves(AttackRegistry.SUNNY_DAY).build());
        TestParticipant golduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLDUCK).ability(AbilityRegistry.CLOUD_NINE).moves(AttackRegistry.RAIN_DANCE).build());
        return helper.setupSingleBattleBuilder(kyogre, golduck).forceChance().start().thenApply(controller -> {
            kyogre.attackOpponent(1);
            golduck.attackOpponent(1);
            controller.takeFullTurn();
            if (!(controller.globalStatusController.getWeather() instanceof Rainy) || !controller.globalStatusController.getWeather().extreme) {
                return TestResult.failure("Cloud Nine should not negate Primordial Sea's ability to prevent other weathers from activating");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkCloudNineDoesNotStopDeltaStream(BattleTestHelper helper) {
        TestParticipant rayquaza = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).ability(AbilityRegistry.DELTA_STREAM).moves(AttackRegistry.SUNNY_DAY).build());
        TestParticipant golduck = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GOLDUCK).ability(AbilityRegistry.CLOUD_NINE).moves(AttackRegistry.RAIN_DANCE).build());
        return helper.setupSingleBattleBuilder(rayquaza, golduck).forceChance().start().thenApply(controller -> {
            rayquaza.attackOpponent(1);
            golduck.attackOpponent(1);
            controller.takeFullTurn();
            if (!(controller.globalStatusController.getWeather() instanceof MysteriousAirCurrent) || !controller.globalStatusController.getWeather().extreme) {
                return TestResult.failure("Cloud Nine should not negate Delta Stream's ability to prevent other weathers from activating");
            }
            return TestResult.success();
        });
    }
}

