/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ClearBodyTests {
    @BattleTest
    public static CompletableFuture<TestResult> testClearBodyNegatesStatDropsFromOpposingEffects(BattleTestHelper helper) {
        TestParticipant tentacruel = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.TENTACRUEL).ability(AbilityRegistry.CLEAR_BODY).moves(AttackRegistry.SPLASH).build());
        Pokemon arbok = helper.createDefaultPokemon(PixelmonSpecies.ARBOK).ability(AbilityRegistry.INTIMIDATE).moves(AttackRegistry.SAND_ATTACK, AttackRegistry.LEER, AttackRegistry.SCARY_FACE).build();
        Pokemon murkrow = helper.createDefaultPokemon(PixelmonSpecies.MURKROW).moves(AttackRegistry.CONFIDE, AttackRegistry.FAKE_TEARS, AttackRegistry.DEFOG).build();
        TestParticipant droppers = helper.createParticipant(2, arbok, murkrow);
        return helper.setupDoubleBattleBuilder(tentacruel, droppers).forceChance().start().thenApply(controller -> {
            tentacruel.attackTarget(1, arbok);
            droppers.attackOpponent(arbok, 1);
            droppers.attackOpponent(murkrow, 1);
            controller.takeFullTurn();
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.ACCURACY) != 0) {
                return TestResult.failure("Clear Body should negate accuracy drops from opposing effects");
            }
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 0) {
                return TestResult.failure("Clear Body should negate attack drops from opposing effects");
            }
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("Clear Body should negate special attack drops from opposing effects");
            }
            tentacruel.attackSelf(1);
            droppers.attackOpponent(arbok, 2);
            droppers.attackOpponent(murkrow, 2);
            controller.takeFullTurn();
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != 0) {
                return TestResult.failure("Clear Body should negate defense drops from opposing effects");
            }
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_DEFENSE) != 0) {
                return TestResult.failure("Clear Body should negate special defense drops from opposing effects");
            }
            tentacruel.attackSelf(1);
            droppers.attackOpponent(arbok, 3);
            droppers.attackOpponent(murkrow, 3);
            controller.takeFullTurn();
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != 0) {
                return TestResult.failure("Clear Body should negate speed drops from opposing effects");
            }
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.EVASION) != 0) {
                return TestResult.failure("Clear Body should negate evasion drops from opposing effects");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkClearBodyDoesNotStopSelfStatNegation(BattleTestHelper helper) {
        TestParticipant tentacruel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TENTACRUEL).ability(AbilityRegistry.CLEAR_BODY).moves(AttackRegistry.SUPERPOWER).build());
        TestParticipant arbok = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARBOK).ability(AbilityRegistry.UNNERVE).moves(AttackRegistry.COIL).build());
        return helper.setupSingleBattleBuilder(tentacruel, arbok).forceChance().start().thenApply(controller -> {
            tentacruel.attackOpponent(1);
            arbok.attackSelf(1);
            controller.takeFullTurn();
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Clear Body should not negate stat drops from the user's moves");
            }
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != -1) {
                return TestResult.failure("Clear Body should not negate stat drops from the user's moves");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkClearBodyDoesNotStopStatBoosts(BattleTestHelper helper) {
        TestParticipant tentacruel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TENTACRUEL).ability(AbilityRegistry.CLEAR_BODY).moves(AttackRegistry.SHADOW_SNEAK).build());
        TestParticipant arbok = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARBOK).ability(AbilityRegistry.UNNERVE).moves(AttackRegistry.SWAGGER).build());
        return helper.setupSingleBattleBuilder(tentacruel, arbok).forceChance().start().thenApply(controller -> {
            tentacruel.attackOpponent(1);
            arbok.attackOpponent(1);
            controller.takeFullTurn();
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != 2) {
                return TestResult.failure("Clear Body should not stop stat boosts");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkClearBodyDoesNotStopAbsoluteStatChanges(BattleTestHelper helper) {
        TestParticipant tentacruel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TENTACRUEL).ability(AbilityRegistry.CLEAR_BODY).moves(AttackRegistry.COIL).build());
        TestParticipant arbok = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ARBOK).ability(AbilityRegistry.UNNERVE).moves(AttackRegistry.TOPSY_TURVY).build());
        return helper.setupSingleBattleBuilder(tentacruel, arbok).forceChance().start().thenApply(controller -> {
            tentacruel.attackSelf(1);
            arbok.attackOpponent(1);
            controller.takeFullTurn();
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Clear Body should not negate absolute stat changes");
            }
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.DEFENSE) != -1) {
                return TestResult.failure("Clear Body should not negate absolute stat changes");
            }
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.ACCURACY) != -1) {
                return TestResult.failure("Clear Body should not negate absolute stat changes");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkClearBodySuppressedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant tentacruel = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.TENTACRUEL).ability(AbilityRegistry.CLEAR_BODY).moves(AttackRegistry.RECOVER).build());
        TestParticipant haxorus = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HAXORUS).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.GROWL).build());
        return helper.setupSingleBattleBuilder(tentacruel, haxorus).forceChance().start().thenApply(controller -> {
            tentacruel.attackSelf(1);
            haxorus.attackOpponent(1);
            controller.takeFullTurn();
            if (tentacruel.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("Clear Body should be suppressed by Mold Breaker");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkClearBodySuppressedByMoldBreakerFromForcedSwap(BattleTestHelper helper) {
        Pokemon swapTo = helper.createDefaultPokemon(PixelmonSpecies.METANG).ability(AbilityRegistry.CLEAR_BODY).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon metagross = helper.createDefaultPokemon(PixelmonSpecies.METAGROSS).ability(AbilityRegistry.CLEAR_BODY).moves(AttackRegistry.SLEEP_TALK).build();
        TestParticipant metagrosses = helper.createParticipant(metagross, swapTo);
        TestParticipant haxorus = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.HAXORUS).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.ROAR, AttackRegistry.STICKY_WEB).build());
        return helper.setupSingleBattleBuilder(metagrosses, haxorus).forceChance().start().thenApply(controller -> {
            metagrosses.attackOpponent(1);
            haxorus.attackOpponent(2);
            controller.takeFullTurn();
            metagrosses.attackOpponent(1);
            metagrosses.switchPokemon(metagross, swapTo);
            haxorus.attackOpponent(1);
            controller.takeFullTurn();
            if (metagrosses.asWrapper().getBattleStats().getStage(BattleStatsType.SPEED) != -1) {
                return TestResult.failure("Clear Body should be suppressed by Mold Breaker if it is forced out by a move");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> checkClearBodyNotOverridingNegativeSixStatStage(BattleTestHelper helper) {
        TestParticipant dragapult = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DRAGAPULT).ability(AbilityRegistry.CLEAR_BODY).moves(AttackRegistry.BELLY_DRUM, AttackRegistry.COUNTER).build());
        TestParticipant malamar = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MALAMAR).moves(AttackRegistry.TOPSY_TURVY, AttackRegistry.GROWL).build());
        return helper.setupSingleBattleBuilder(dragapult, malamar).forceChance().start().thenApply(controller -> {
            dragapult.attackSelf(1);
            malamar.attackOpponent(1);
            controller.takeFullTurn();
            dragapult.attackOpponent(2);
            malamar.attackOpponent(2);
            controller.advanceToMoves();
            controller.doTurnLogic();
            if (dragapult.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -6) {
                return TestResult.failure("Stat should remain at -6 when affected by stat drop in ClearBody pokemon");
            }
            if (!dragapult.lastMessageKey().contains("attacktoolow")) {
                return TestResult.failure("Attack being at -6 should block Growl before ClearBody prevents it.");
            }
            return TestResult.success();
        });
    }
}

