/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.log.action.type.HealPokemonAction;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class CheekPouchTests {
    @BattleTest
    public static CompletableFuture<TestResult> testCheekPouchActivatesCorrectly(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.CHEEK_POUCH).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant pichu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PICHU).moves(AttackRegistry.NUZZLE).build());
        return helper.createSingleBattle(wynaut, pichu).thenApply(controller -> {
            wynaut.attackOpponent(1);
            pichu.attackOpponent(1);
            controller.takeFullTurn();
            if (!wynaut.asWrapper().hasFullHealth()) {
                return TestResult.failure("Cheek Pouch should restore 1/3 HP to the user after eating a Berry");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testCheekPouchDoesNotActivateAtFullHP(BattleTestHelper helper) {
        TestParticipant wynaut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.CHEEK_POUCH).heldItem(PixelmonItems.lum_berry).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant pichu = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PICHU).moves(AttackRegistry.GLARE).build());
        return helper.createSingleBattle(wynaut, pichu).thenApply(controller -> {
            wynaut.attackOpponent(1);
            pichu.attackOpponent(1);
            controller.takeFullTurn();
            if (controller.battleLog.getAllActions().stream().anyMatch(HealPokemonAction.class::isInstance)) {
                return TestResult.failure("Cheek Pouch should not activate if the user was at full HP");
            }
            return TestResult.success();
        });
    }
}

