/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class BerserkTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBerserkTriggersBeforeBerryOnSingleHitMoves(BattleTestHelper helper) {
        TestParticipant drampa = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DRAMPA).ability(AbilityRegistry.BERSERK).heldItem(PixelmonItems.sitrus_berry).ev(BattleStatsType.HP, 4).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant wyanut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.SUPER_FANG).build());
        return helper.createSingleBattle(drampa, wyanut).thenApply(controller -> {
            drampa.attackOpponent(1);
            wyanut.attackOpponent(1);
            controller.takeFullTurn();
            if (drampa.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("Berserk should activate prior to healing from Sitrus Berry");
            }
            double targetHealth = Math.floor((double)drampa.asWrapper().getMaxHealth() / 2.0) + Math.floor((double)drampa.asWrapper().getMaxHealth() / 4.0);
            if ((double)drampa.asWrapper().getHealth() != targetHealth) {
                return TestResult.failure("Berserk should activate prior to healing from Sitrus Berry");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBerserkTriggersAfterBerryInMultiHitMove(BattleTestHelper helper) {
        TestParticipant drampa = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DRAMPA).ability(AbilityRegistry.BERSERK).heldItem(PixelmonItems.sitrus_berry).ev(BattleStatsType.HP, 4).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant wyanut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.PARENTAL_BOND).moves(AttackRegistry.SEISMIC_TOSS).build());
        return helper.createSingleBattle(drampa, wyanut).thenApply(controller -> {
            drampa.attackOpponent(1);
            wyanut.attackOpponent(1);
            controller.takeFullTurn();
            if (drampa.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 0) {
                return TestResult.failure("Berserk should not activate prior to healing from Sitrus Berry after a multi-hit move");
            }
            double targetHealth = (double)(drampa.asWrapper().getMaxHealth() - 200) + Math.floor((double)drampa.asWrapper().getMaxHealth() / 4.0);
            if ((double)drampa.asWrapper().getHealth() != targetHealth) {
                return TestResult.failure("Berserk should not activate prior to healing from Sitrus Berry after a multi-hit move");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBerserkDoesNotTriggerAfterDartHitStartingAt50Percent(BattleTestHelper helper) {
        Pokemon drampa = helper.createDefaultPokemon(PixelmonSpecies.DRAMPA).ability(AbilityRegistry.BERSERK).ev(BattleStatsType.HP, 4).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon togedemaru = helper.createDefaultPokemon(PixelmonSpecies.TOGEDEMARU).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.SUPER_FANG).build();
        TestParticipant pair = helper.createParticipant(2, drampa, togedemaru);
        TestParticipant wyanut = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.DRAGON_DARTS).build());
        return helper.createSingleBattle(pair, wyanut).thenApply(controller -> {
            pair.attackOpponent(drampa, 1);
            pair.attackTarget(togedemaru, 1, drampa);
            wyanut.attackOpponent(1);
            controller.advanceToMoves();
            controller.doTurnLogic();
            PixelmonWrapper drampaWrapper = pair.asWrapper(drampa);
            if (drampaWrapper.getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("Berserk should activate on going to half by an ally's attack");
            }
            controller.doTurnLogic();
            controller.doTurnLogic();
            if (drampaWrapper.getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("Berserk should not activate on going from half to below it with dragon darts");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBerserkTriggersAfterMultiHitWithHitsStartingBelow50Percent(BattleTestHelper helper) {
        Pokemon drampa = helper.createDefaultPokemon(PixelmonSpecies.DRAMPA).ability(AbilityRegistry.BERSERK).ev(BattleStatsType.HP, 4).moves(AttackRegistry.SLEEP_TALK).build();
        Pokemon togedemaru = helper.createDefaultPokemon(PixelmonSpecies.TOGEDEMARU).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.SUPER_FANG).build();
        TestParticipant pair = helper.createParticipant(2, drampa, togedemaru);
        TestParticipant wyanut = helper.createParticipant(2, helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).moves(AttackRegistry.DRAGON_DARTS).build());
        return helper.createSingleBattle(pair, wyanut).thenApply(controller -> {
            pair.attackOpponent(drampa, 1);
            pair.attackTarget(togedemaru, 1, drampa);
            wyanut.attackOpponent(1);
            controller.advanceToMoves();
            controller.doTurnLogic();
            PixelmonWrapper drampaWrapper = pair.asWrapper(drampa);
            if (drampaWrapper.getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("Berserk should activate on going to half by an ally's attack");
            }
            controller.doTurnLogic();
            controller.doTurnLogic();
            if (drampaWrapper.getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("Berserk should not activate on going from half to below it with dragon darts");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBerserkTriggersOnceIfMultiHitCrossesHalfTwice(BattleTestHelper helper) {
        TestParticipant drampa = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DRAMPA).ability(AbilityRegistry.BERSERK).ev(BattleStatsType.HP, 4).heldItem(PixelmonItems.sitrus_berry).moves(AttackRegistry.SLEEP_TALK).build());
        TestParticipant wyanut = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.WYNAUT).ability(AbilityRegistry.PARENTAL_BOND).heldItem(PixelmonItems.zoom_lens).moves(AttackRegistry.SUPER_FANG).build());
        return helper.createSingleBattle(drampa, wyanut).thenApply(controller -> {
            drampa.attackOpponent(1);
            wyanut.attackOpponent(1);
            controller.takeFullTurn();
            if (drampa.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) != 1) {
                return TestResult.failure("Berserk should activate once on multi hit crossing half twice");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBerserkTriggersAfterMultiHitWithHitsAfterReachingBelow50Percent(BattleTestHelper helper) {
        TestParticipant moltres = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MOLTRES).form("galarian").ability(AbilityRegistry.BERSERK).moves(AttackRegistry.ENDURE).build());
        TestParticipant cloyster = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CLOYSTER).ev(BattleStatsType.ATTACK, 252).ability(AbilityRegistry.SKILL_LINK).moves(AttackRegistry.ICICLE_SPEAR).build());
        return helper.setupSingleBattleBuilder(moltres, cloyster).forceChance().start().thenApply(controller -> {
            moltres.attackSelf(1);
            cloyster.attackOpponent(1);
            controller.takeFullTurn();
            if (moltres.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) < 1) {
                return TestResult.failure("Berserk should trigger from multi-hit moves with attacks below half");
            }
            if (moltres.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_ATTACK) > 1) {
                return TestResult.failure("Berserk should not trigger more than once from multi-hit moves with extra attacks below half");
            }
            return TestResult.success();
        });
    }
}

