/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class BattleArmorTests {
    @BattleTest
    public static CompletableFuture<TestResult> testBattleArmorStopsCrits(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CRYOGONAL).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.FROST_BREATH).build());
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLOWBRO).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.QUICK_ATTACK).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            defender.asWrapper().getBattleStats().modifyStat(1, BattleStatsType.SPECIAL_DEFENSE);
            attacker.asWrapper().getBattleStats().modifyStat(-1, BattleStatsType.SPECIAL_ATTACK);
            attacker.attackOpponent(1);
            defender.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(defender.asWrapper().getHealthDeficit(), 16, 21);
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testBattleArmorIsBypassedByMoldBreaker(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CRYOGONAL).ability(AbilityRegistry.MOLD_BREAKER).heldItem(PixelmonItems.zoom_lens).moves(AttackRegistry.FROST_BREATH).build());
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SLOWBRO).ability(AbilityRegistry.BATTLE_ARMOUR).moves(AttackRegistry.QUICK_ATTACK).build());
        return helper.setupSingleBattleBuilder(attacker, defender).forceChance().start().thenApply(controller -> {
            defender.asWrapper().getBattleStats().modifyStat(1, BattleStatsType.SPECIAL_DEFENSE);
            attacker.asWrapper().getBattleStats().modifyStat(-1, BattleStatsType.SPECIAL_ATTACK);
            attacker.attackOpponent(1);
            defender.attackOpponent(1);
            controller.takeFullTurn();
            return TestResult.damageResult(defender.asWrapper().getHealthDeficit(), 57, 67);
        });
    }
}

