/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ArenaTrapTests {
    @BattleTest
    public static CompletableFuture<TestResult> testArenaTrap(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.DUGTRIO).ability(AbilityRegistry.ARENA_TRAP).moves(AttackRegistry.SNORE, AttackRegistry.TELEKINESIS, AttackRegistry.GRAVITY).build());
        Pokemon tornadus = helper.createDefaultPokemon(PixelmonSpecies.TORNADUS).ability(AbilityRegistry.DEFIANT).moves(AttackRegistry.TAILWIND).build();
        Pokemon heatran = helper.createDefaultPokemon(PixelmonSpecies.HEATRAN).ability(AbilityRegistry.FLASH_FIRE).heldItem(PixelmonItems.air_balloon).moves(AttackRegistry.ROAR).build();
        Pokemon claydol = helper.createDefaultPokemon(PixelmonSpecies.CLAYDOL).ability(AbilityRegistry.LEVITATE).moves(AttackRegistry.REST).build();
        Pokemon dusknoir = helper.createDefaultPokemon(PixelmonSpecies.DUSKNOIR).ability(AbilityRegistry.FRISK).moves(AttackRegistry.REST).build();
        Pokemon magnezone = helper.createDefaultPokemon(PixelmonSpecies.MAGNEZONE).ability(AbilityRegistry.MAGNET_PULL).moves(AttackRegistry.MAGNET_RISE).build();
        Pokemon vaporeon = helper.createDefaultPokemon(PixelmonSpecies.VAPOREON).ability(AbilityRegistry.WATER_ABSORB).moves(AttackRegistry.ROAR).build();
        TestParticipant defense = helper.createParticipant(tornadus, heatran, claydol, dusknoir, magnezone, vaporeon);
        return helper.createSingleBattle(defense, attacker).thenApply(controller -> {
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                defense.switchPokemon(tornadus, heatran);
            });
            if (!defense.asWrapper().getSpecies().is(PixelmonSpecies.HEATRAN)) {
                return TestResult.failure("Arena Trap should not prevent flying Pokemon from switching out normally.");
            }
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                defense.switchPokemon(heatran, claydol);
            });
            if (!defense.asWrapper().getSpecies().is(PixelmonSpecies.CLAYDOL)) {
                return TestResult.failure("Arena Trap should not prevent Pokemon with an AirBalloon from switching out normally.");
            }
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                defense.switchPokemon(claydol, dusknoir);
            });
            if (!defense.asWrapper().getSpecies().is(PixelmonSpecies.DUSKNOIR)) {
                return TestResult.failure("Arena Trap should not prevent levitating Pokemon from switching out normally");
            }
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                defense.switchPokemon(dusknoir, magnezone);
            });
            if (!defense.asWrapper().getSpecies().is(PixelmonSpecies.MAGNEZONE)) {
                return TestResult.failure("Arena Trap should not prevent Ghost-type Pokemon from switching out normally");
            }
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                defense.switchPokemon(magnezone, vaporeon);
            });
            if (!defense.asWrapper().getSpecies().is(PixelmonSpecies.MAGNEZONE)) {
                return TestResult.failure("Arena Trap should prevent grounded Pokemon that are not immune to trapping from switching out normally");
            }
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                defense.attackAutoTarget(1);
            });
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                defense.switchPokemon(magnezone, vaporeon);
            });
            if (!defense.asWrapper().getSpecies().is(PixelmonSpecies.VAPOREON)) {
                return TestResult.failure("Arena Trap should not prevent Pokemon levitating with MagnetRise from switching out normally");
            }
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                defense.switchPokemon(vaporeon, tornadus);
            });
            if (!defense.asWrapper().getSpecies().is(PixelmonSpecies.VAPOREON)) {
                return TestResult.failure("MagnetRise should only work on the pokemon that used it.");
            }
            attacker.attackOpponent(2);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                defense.switchPokemon(vaporeon, tornadus);
            });
            if (!defense.asWrapper().getSpecies().is(PixelmonSpecies.TORNADUS)) {
                return TestResult.failure("Telekinesis should free its target from Arena Trap.");
            }
            attacker.attackAutoTarget(3);
            defense.attackSelf(1);
            controller.takeFullTurn();
            controller.takeFullTurn(() -> {
                attacker.attackOpponent(1);
                defense.switchPokemon(tornadus, dusknoir);
            });
            if (!defense.asWrapper().getSpecies().is(PixelmonSpecies.TORNADUS)) {
                return TestResult.failure("Gravity should remove airborne status, trapping flying pokemon in ArenaTrap");
            }
            return TestResult.success();
        });
    }
}

