/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class AngerPointTests {
    @BattleTest
    public static CompletableFuture<TestResult> testAngerPointCritStatRaise(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CRYOGONAL).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.FROST_BREATH).build());
        TestParticipant angerIncrease = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PRIMEAPE).ability(AbilityRegistry.ANGER_POINT).moves(AttackRegistry.ENDURE).build());
        return helper.setupSingleBattleBuilder(attacker, angerIncrease).forceChance().start().thenApply(battleController -> {
            angerIncrease.attackSelf(1);
            attacker.attackOpponent(1);
            battleController.takeFullTurn();
            if (angerIncrease.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == 6) {
                return TestResult.success();
            }
            return TestResult.failure("Anger point should maximize Attack when hit by a critical hit");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testAngerPointCritStatRaiseIgnoringMoldBreaker(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PINSIR).ability(AbilityRegistry.MOLD_BREAKER).moves(AttackRegistry.STORM_THROW).build());
        TestParticipant angerIncrease = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PRIMEAPE).ability(AbilityRegistry.ANGER_POINT).moves(AttackRegistry.ENDURE).build());
        return helper.createSingleBattle(attacker, angerIncrease).thenApply(controller -> {
            attacker.attackOpponent(1);
            angerIncrease.attackSelf(1);
            controller.takeFullTurn();
            if (angerIncrease.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == 6) {
                return TestResult.success();
            }
            return TestResult.failure("Anger point should maximize Attack when hit by a critical hit even if the foe has Mold Breaker");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testAngerPointDoesNotIncreaseStatFromDealingCritical(BattleTestHelper helper) {
        TestParticipant defender = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CRYOGONAL).ability(AbilityRegistry.NO_GUARD).moves(AttackRegistry.ENDURE).build());
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PRIMEAPE).ability(AbilityRegistry.ANGER_POINT).moves(AttackRegistry.STORM_THROW).build());
        return helper.createSingleBattle(defender, attacker).thenApply(controller -> {
            defender.attackSelf(1);
            attacker.attackOpponent(1);
            controller.takeFullTurn();
            if (attacker.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == 0) {
                return TestResult.success();
            }
            return TestResult.failure("Anger point should not maximize Attack when dealing a critical hit");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testAngerPointDoesNotStatIncreaseBehindSubstitute(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CRYOGONAL).ability(AbilityRegistry.NO_GUARD).heldItem(PixelmonItems.lagging_tail).moves(AttackRegistry.FROST_BREATH).build());
        TestParticipant angerpoint = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.PRIMEAPE).ability(AbilityRegistry.ANGER_POINT).moves(AttackRegistry.SUBSTITUTE).build());
        return helper.createSingleBattle(attacker, angerpoint).thenApply(controller -> {
            attacker.attackOpponent(1);
            angerpoint.attackSelf(1);
            controller.takeFullTurn();
            if (angerpoint.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) == 0) {
                return TestResult.success();
            }
            return TestResult.failure("Anger point should not maximize Attack when substitute is hit by a crit");
        });
    }
}

