/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl.ability;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class AftermathTests {
    @BattleTest
    public static CompletableFuture<TestResult> testAftermath(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GALVANTULA).moves(AttackRegistry.LUNGE).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHIFTRY).ability(AbilityRegistry.AFTERMATH).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackOpponent(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            int maxHealth = attacker.asWrapper().getMaxHealth();
            if ((double)attacker.asWrapper().getHealth() == (double)maxHealth - Math.floor(0.25 * (double)maxHealth)) {
                return TestResult.success();
            }
            return TestResult.failure("Should damage the attacker by 1/4 of their max HP when the Pokemon is KOd by a contact move");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testAftermathDoesntHarmKOByNonContact(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GALVANTULA).ability(AbilityRegistry.LONG_REACH).moves(AttackRegistry.LUNGE).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHIFTRY).ability(AbilityRegistry.AFTERMATH).moves(AttackRegistry.SLEEP_TALK).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackOpponent(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            if (attacker.asWrapper().hasFullHealth()) {
                return TestResult.success();
            }
            return TestResult.failure("Should not damage the attacker when the Pokemon is KOd by a non-contact move");
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testAftermathDoesntHarmKOByIndirectDamage(BattleTestHelper helper) {
        TestParticipant attacker = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.GALVANTULA).ability(AbilityRegistry.COMPOUND_EYES).moves(AttackRegistry.LUNGE, AttackRegistry.TOXIC).build());
        TestParticipant defense = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SHIFTRY).ability(AbilityRegistry.AFTERMATH).moves(AttackRegistry.SLEEP_TALK).heldItem(PixelmonItems.focus_sash).build());
        return helper.createSingleBattle(attacker, defense).thenApply(controller -> {
            attacker.attackOpponent(1);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            attacker.attackOpponent(2);
            defense.attackOpponent(1);
            controller.takeFullTurn();
            if (defense.allPokemon[0].isFainted() && attacker.asWrapper().hasFullHealth()) {
                return TestResult.success();
            }
            return TestResult.failure("Should not damage the attacker when the Pokemon is KOd by indirect damage");
        });
    }
}

