/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SpreadMoveTest {
    public static CompletableFuture<TestResult> testSpreadMovesDamageAllTargetsAtOnce(BattleTestHelper helper) {
        TestParticipant spectrier = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.SPECTRIER).moves(AttackRegistry.ASTRAL_BARRAGE).heldItem(PixelmonItems.choice_specs).build());
        Pokemon clefable = helper.createDefaultPokemon(PixelmonSpecies.CLEFABLE).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SPLASH).build();
        Pokemon regieleki = helper.createDefaultPokemon(PixelmonSpecies.REGIELEKI).ability(AbilityRegistry.SHELL_ARMOUR).moves(AttackRegistry.SPLASH).level(40).build();
        TestParticipant targets = helper.createParticipant(2, clefable, regieleki);
        return helper.setupDoubleBattleBuilder(spectrier, targets).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                targets.attackAuto(clefable);
                targets.attackAuto(regieleki);
                spectrier.attackAutoTarget(1);
            });
            if (targets.asWrapper(regieleki).isAlive()) {
                return TestResult.failure("Regieleki should have fainted due to the attack");
            }
            if (targets.asWrapper(clefable).isFainted()) {
                return TestResult.failure("Clefable should have survived the attack");
            }
            return TestResult.success();
        });
    }
}

