/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.log.AttackResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class SpammableDestinyBondTest {
    @BattleTest
    public static CompletableFuture<TestResult> testSpammableDestinyBond(BattleTestHelper helper) {
        TestParticipant magikarpOne = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.DESTINY_BOND).build());
        TestParticipant magikarpTwo = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.BULK_UP).build());
        return helper.setupSingleBattleBuilder(magikarpOne, magikarpTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                magikarpOne.attackAuto();
                magikarpTwo.attackAuto();
            });
            controller.takeFullTurn(() -> {
                magikarpOne.attackAuto();
                magikarpTwo.attackAuto();
            });
            if (magikarpOne.asWrapper().attack.moveResult.result != AttackResult.failed) {
                return TestResult.failure("Destiny Bond was used twice in a row successfully.");
            }
            if (magikarpOne.asWrapper().hasStatus(StatusType.DestinyBond)) {
                return TestResult.failure("Destiny Bond status was maintained despite failing.");
            }
            return TestResult.success();
        });
    }
}

