/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ShellTrapTest {
    @BattleTest
    public static CompletableFuture<TestResult> testShellTrap(BattleTestHelper helper) {
        Attack rage = AttackRegistry.RAGE.get().ofMutable();
        Attack shellTrap = AttackRegistry.SHELL_TRAP.get().ofMutable();
        Pokemon trapper = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).iv(BattleStatsType.SPEED, 0).moves(AttackRegistry.SHELL_TRAP).build();
        TestParticipant shelltrap = helper.createParticipant(trapper);
        Pokemon magikarpOne = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.RAGE).build();
        Pokemon magikarpTwo = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.RAGE).build();
        TestParticipant targets = helper.createParticipant(2, magikarpOne, magikarpTwo);
        return helper.setupDoubleBattleBuilder(shelltrap, targets).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                shelltrap.attackAuto();
                targets.attackTarget(magikarpOne, 1, trapper);
                targets.attackTarget(magikarpTwo, 1, trapper);
            });
            if (targets.asWrapper(magikarpOne).hasFullHealth() || targets.asWrapper(magikarpTwo).hasFullHealth()) {
                return TestResult.failure("The Shell Trap did not activate.");
            }
            return TestResult.success();
        });
    }
}

