/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.battles.status.MysteriousAirCurrent;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class NonExtremeWeatherFailsDuringDeltaStreamTest {
    @BattleTest
    public static CompletableFuture<TestResult> testNonExtremeWeatherFailsDuringDeltaStream(BattleTestHelper helper) {
        TestParticipant rayquaza = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.RAYQUAZA).moves(AttackRegistry.DRAGON_ASCENT, AttackRegistry.PROTECT).build());
        TestParticipant castform = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.CASTFORM).moves(AttackRegistry.ENDURE, AttackRegistry.SUNNY_DAY).build());
        return helper.setupSingleBattleBuilder(rayquaza, castform).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                rayquaza.evolve();
                rayquaza.attackOpponent(1);
                castform.attackSelf(1);
            });
            controller.takeFullTurn(() -> {
                rayquaza.attackSelf(2);
                castform.attackSelf(2);
            });
            if (controller.globalStatusController.hasStatus(StatusType.Sunny)) {
                return TestResult.failure("Castform managed to start Sun under a MysteriousAirCurrent");
            }
            if (controller.globalStatusController.getWeather() instanceof MysteriousAirCurrent) {
                return TestResult.success();
            }
            return TestResult.failure("The weather Rayquaza created disappeared.");
        });
    }
}

