/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BattleStatsType;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class HiddenPowerMaxMoveTypingTest {
    private HiddenPowerMaxMoveTypingTest() {
        throw new UnsupportedOperationException("Unit test");
    }

    @BattleTest
    public static CompletableFuture<TestResult> testMaxHiddenPowerHasCorrectTypingHPDark(BattleTestHelper helper) {
        TestParticipant unown = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.UNOWN).moves(AttackRegistry.HIDDEN_POWER).build());
        TestParticipant target = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LATIAS).moves(AttackRegistry.LUCKY_CHANT).heldItem(PixelmonItems.colbur_berry).build());
        return helper.setupSingleBattleBuilder(unown, target).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                unown.attackAuto();
                target.attackSelf(1);
                unown.evolve();
            });
            if (target.asWrapper().hasFullHealth()) {
                return TestResult.failure("The attack didn't hit.");
            }
            if (target.asWrapper().hasHeldItem()) {
                return TestResult.failure("The Max Hidden Power attack was not a dark type attack.");
            }
            if (target.asWrapper().getBattleStats().getStage(BattleStatsType.SPECIAL_DEFENSE) != -1) {
                return TestResult.failure("The dark type attack was not Max Darkness.");
            }
            return TestResult.success();
        });
    }

    @BattleTest
    public static CompletableFuture<TestResult> testMaxHiddenPowerHasCorrectTypingHPDragon(BattleTestHelper helper) {
        TestParticipant unown = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.UNOWN).moves(AttackRegistry.HIDDEN_POWER).iv(BattleStatsType.ATTACK, 30).build());
        TestParticipant target = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.LATIAS).moves(AttackRegistry.LUCKY_CHANT).heldItem(PixelmonItems.haban_berry).build());
        return helper.setupSingleBattleBuilder(unown, target).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                unown.attackAuto();
                target.attackSelf(1);
                unown.evolve();
            });
            if (target.asWrapper().hasFullHealth()) {
                return TestResult.failure("The attack didn't hit.");
            }
            if (target.asWrapper().hasHeldItem()) {
                return TestResult.failure("The Max Hidden Power attack was not a dragon type attack.");
            }
            if (target.asWrapper().getBattleStats().getStage(BattleStatsType.ATTACK) != -1) {
                return TestResult.failure("The dragon type attack was not Max Wyrmwind.");
            }
            return TestResult.success();
        });
    }
}

