/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class DancerTest {
    @BattleTest
    public static CompletableFuture<TestResult> testDancerCopiesDanceMoves(BattleTestHelper helper) {
        TestParticipant oricorioOne = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ORICORIO).form("baile").moves(AttackRegistry.AQUA_STEP, AttackRegistry.FIERY_DANCE, AttackRegistry.REVELATION_DANCE, AttackRegistry.PETAL_DANCE).build());
        TestParticipant oricorioTwo = helper.createParticipant(helper.createDefaultPokemon(PixelmonSpecies.ORICORIO).form("baile").moves(AttackRegistry.SLEEP_TALK).build());
        return helper.setupSingleBattleBuilder(oricorioOne, oricorioTwo).forceChance().start().thenApply(controller -> {
            controller.takeFullTurn(() -> {
                oricorioOne.attackOpponent(1);
                oricorioTwo.attackOpponent(1);
            });
            if (oricorioOne.asWrapper().hasFullHealth()) {
                return TestResult.failure("The dancer ability did not activate with Aqua Step.");
            }
            if (oricorioTwo.asWrapper().hasFullHealth()) {
                return TestResult.failure("The attacking Oricorio did not deal damage with Aqua Step.");
            }
            oricorioOne.asWrapper().healByPercent(100.0f);
            oricorioTwo.asWrapper().healByPercent(100.0f);
            controller.takeFullTurn(() -> {
                oricorioOne.attackOpponent(2);
                oricorioTwo.attackOpponent(1);
            });
            if (oricorioOne.asWrapper().hasFullHealth()) {
                return TestResult.failure("The dancer ability did not activate with Fiery Dance.");
            }
            if (oricorioTwo.asWrapper().hasFullHealth()) {
                return TestResult.failure("The attacking Oricorio did not deal damage with Fiery Dance.");
            }
            oricorioOne.asWrapper().healByPercent(100.0f);
            oricorioTwo.asWrapper().healByPercent(100.0f);
            controller.takeFullTurn(() -> {
                oricorioOne.attackOpponent(3);
                oricorioTwo.attackOpponent(1);
            });
            if (oricorioOne.asWrapper().hasFullHealth()) {
                return TestResult.failure("The dancer ability did not activate with Revelation Dance.");
            }
            if (oricorioTwo.asWrapper().hasFullHealth()) {
                return TestResult.failure("The attacking Oricorio did not deal damage with Revelation Dance.");
            }
            oricorioOne.asWrapper().healByPercent(100.0f);
            oricorioTwo.asWrapper().healByPercent(100.0f);
            controller.takeFullTurn(() -> {
                oricorioOne.attackOpponent(4);
                oricorioTwo.attackOpponent(1);
            });
            if (oricorioOne.asWrapper().hasFullHealth()) {
                return TestResult.failure("The dancer ability did not activate with Petal Dance.");
            }
            if (oricorioTwo.asWrapper().hasFullHealth()) {
                return TestResult.failure("The attacking Oricorio did not deal damage with Petal Dance.");
            }
            return TestResult.success();
        });
    }
}

