/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.impl;

import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import java.util.concurrent.CompletableFuture;

@BattleTestClass
public class ClangorousSoulblazeCorrectBoostAmountTest {
    @BattleTest
    public static CompletableFuture<TestResult> testClangorousSoulblazeCorrectBoostAmount(BattleTestHelper helper) {
        Pokemon magikarp1 = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.SPLASH).build();
        Pokemon magikarp2 = helper.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.SPLASH).build();
        TestParticipant doubleTarget = helper.createParticipant(2, magikarp1, magikarp2);
        Pokemon komoo0 = helper.createDefaultPokemon(PixelmonSpecies.KOMMOO).moves(AttackRegistry.CLANGING_SCALES).heldItem(PixelmonItems.kommonium_z).build();
        TestParticipant kommoTrainer = helper.createParticipant(komoo0);
        return helper.setupDoubleBattleBuilder(doubleTarget, kommoTrainer).start().thenApply(controller -> {
            kommoTrainer.attackAuto(komoo0);
            kommoTrainer.useZMove();
            doubleTarget.attackAuto(magikarp1);
            doubleTarget.attackAuto(magikarp2);
            controller.takeFullTurn();
            int[] stages = ((PixelmonWrapper)kommoTrainer.controlledPokemon.get(0)).getBattleStats().getStages();
            for (int i = 2; i < stages.length; ++i) {
                if (stages[i] == 1) continue;
                return TestResult.failure("The Kommo-O achieved an incorrect boost (" + stages[i] + ") in a double battle instead of just a +1 boost.");
            }
            if (stages[0] != 0 || stages[1] != 0) {
                return TestResult.failure("The Kommo-O achieved an incorrect boost on its Accuracy or Evasion.");
            }
            return TestResult.success();
        });
    }
}

