/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test;

import javax.annotation.Nullable;

public class TestResult {
    private final boolean success;
    @Nullable
    private final String reason;
    @Nullable
    private final Throwable error;

    private TestResult(boolean success, @Nullable String reason, @Nullable Throwable error) {
        this.success = success;
        this.reason = reason;
        this.error = error;
    }

    public boolean isSuccess() {
        return this.success;
    }

    @Nullable
    public String getReason() {
        return this.reason;
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public static TestResult success() {
        return new TestResult(true, null, null);
    }

    public static TestResult failure(String reason) {
        return new TestResult(false, reason, null);
    }

    public static TestResult error(Throwable throwable) {
        return new TestResult(false, throwable.getMessage(), throwable);
    }

    public static TestResult damageResult(int damage, int min, int max) {
        String damageRange = "[" + min + "," + max + "]";
        if (min <= damage) {
            if (damage <= max) {
                return TestResult.success();
            }
            return TestResult.failure("Damage (" + damage + ") is too high, outside of damage range " + damageRange);
        }
        return TestResult.failure("Damage (" + damage + ") is too low, outside of damage range " + damageRange);
    }

    public static TestResult equal(double actual, double expected) {
        if (actual == expected) {
            return TestResult.success();
        }
        return TestResult.failure("Expected " + expected + ", but got " + actual);
    }

    public static TestResult equal(double actual, double expected, String error) {
        if (actual == expected) {
            return TestResult.success();
        }
        return TestResult.failure(error + " Expected " + expected + ", but got " + actual);
    }
}

