/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.test.BattleTest;
import com.pixelmonmod.pixelmon.api.test.BattleTestClass;
import com.pixelmonmod.pixelmon.api.test.BattleTestHelper;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class BattleTestRegistry {
    private static final List<TestData> REGISTERED_TESTS = Lists.newCopyOnWriteArrayList();
    private static final Type TEST_HOLDER = Type.getType(BattleTestClass.class);

    public static void init() {
        ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> TEST_HOLDER.equals((Object)a.annotationType())).forEach(a -> BattleTestRegistry.register(BattleTestRegistry.getClass(a)));
    }

    private static Class<?> getClass(ModFileScanData.AnnotationData annotationData) {
        try {
            return Class.forName(annotationData.clazz().getClassName(), true, Pixelmon.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void register(Class<?> testClass) {
        for (Method declaredMethod : testClass.getDeclaredMethods()) {
            BattleTest testData;
            if (!BattleTestRegistry.isValidTestMethod(declaredMethod) || (testData = declaredMethod.getAnnotation(BattleTest.class)) == null) continue;
            declaredMethod.setAccessible(true);
            REGISTERED_TESTS.add(new TestData(testClass.getSimpleName().toLowerCase(Locale.ENGLISH) + "." + declaredMethod.getName().toLowerCase(Locale.ENGLISH), testData.experimental(), () -> {
                try {
                    return (CompletableFuture)declaredMethod.invoke(null, new BattleTestHelper());
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    return CompletableFuture.completedFuture(TestResult.error(e));
                }
            }));
        }
    }

    public static CompletableFuture<Boolean> runTests(Loggable loggable, boolean experimental) {
        AtomicInteger passes = new AtomicInteger(0);
        AtomicInteger failures = new AtomicInteger(0);
        ArrayList results = Lists.newArrayList();
        ArrayList testResults = Lists.newArrayList();
        loggable.log("Running " + REGISTERED_TESTS.size() + " battle tests");
        for (TestData registeredTest : REGISTERED_TESTS) {
            if (registeredTest.experimental() && !experimental) continue;
            loggable.log("Starting test: " + registeredTest.id());
            results.add(((CompletableFuture)registeredTest.testLogic.get().thenApply(testResult -> {
                loggable.log("Completed test " + registeredTest.id() + " " + (String)(testResult.isSuccess() ? "successfully" : "but it failed. " + testResult.getReason()));
                testResults.add(testResult);
                if (testResult.isSuccess()) {
                    passes.incrementAndGet();
                } else {
                    failures.incrementAndGet();
                }
                return testResult;
            })).exceptionally(throwable -> {
                TestResult error = TestResult.error(throwable);
                loggable.log("Completed test " + registeredTest.id() + " but it failed. " + throwable.getMessage());
                loggable.log(Arrays.stream(throwable.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.joining(System.lineSeparator())));
                testResults.add(TestResult.error(throwable));
                failures.incrementAndGet();
                return error;
            }));
        }
        return CompletableFuture.allOf(results.toArray(new CompletableFuture[0])).thenApply(unused -> {
            loggable.log("Battle tests finished - " + passes.get() + " passed, " + failures.get() + " failed");
            return failures.get() == 0;
        });
    }

    private static boolean isValidTestMethod(Method method) {
        if (!Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        if (method.getParameterCount() != 1) {
            return false;
        }
        return method.getReturnType() == CompletableFuture.class;
    }

    public static List<TestData> getRegisteredTests() {
        return REGISTERED_TESTS;
    }

    public record TestData(String id, boolean experimental, Supplier<CompletableFuture<TestResult>> testLogic) {
    }

    public static interface Loggable {
        public void log(String var1);
    }
}

