/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test;

import com.pixelmonmod.api.registry.RegistryValue;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.Nature;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.battles.api.BattleBuilder;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TestParticipant;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.concurrent.CompletableFuture;

public class BattleTestHelper {
    protected BattleTestHelper() {
    }

    public TestParticipant createParticipant(Pokemon ... pokemon) {
        return this.createParticipant(1, pokemon);
    }

    public TestParticipant createParticipant(int numControlled, Pokemon ... pokemon) {
        return new TestParticipant(numControlled, pokemon);
    }

    public CompletableFuture<BattleController> createSingleBattle(BattleParticipant teamOne, BattleParticipant teamTwo) {
        return BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(teamOne).teamTwo(teamTwo).start().thenApply(battleController -> {
            this.skipTicks((BattleController)battleController, 10);
            return battleController;
        });
    }

    public BattleBuilder setupSingleBattleBuilder(BattleParticipant teamOne, BattleParticipant teamTwo) {
        return BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(teamOne).teamTwo(teamTwo).setupHandler(battleController -> this.skipTicks((BattleController)battleController, 10));
    }

    public BattleBuilder setupSingleBattleBuilderWithoutSwitchIns(BattleParticipant teamOne, BattleParticipant teamTwo) {
        return BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(teamOne).teamTwo(teamTwo);
    }

    public BattleBuilder setupDoubleBattleBuilder(BattleParticipant teamOne, BattleParticipant teamTwo) {
        teamOne.numControlledPokemon = 2;
        teamTwo.numControlledPokemon = 2;
        return BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.DOUBLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(teamOne).teamTwo(teamTwo).setupHandler(battleController -> this.skipTicks((BattleController)battleController, 10));
    }

    public BattleBuilder setupDoubleBattleBuilder(BattleParticipant teamOneFirst, BattleParticipant teamOneSecond, BattleParticipant teamTwoFirst, BattleParticipant teamTwoSecond) {
        return BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.DOUBLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(teamOneFirst, teamOneSecond).teamTwo(teamTwoFirst, teamTwoSecond).setupHandler(battleController -> this.skipTicks((BattleController)battleController, 10));
    }

    public BattleBuilder setupTripleBattleBuilder(BattleParticipant teamOne, BattleParticipant teamTwo) {
        teamOne.numControlledPokemon = 3;
        teamTwo.numControlledPokemon = 3;
        return BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.TRIPLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(teamOne).teamTwo(teamTwo).setupHandler(battleController -> this.skipTicks((BattleController)battleController, 10));
    }

    public void skipTicks(BattleController controller, int ticks) {
        for (int i = 0; i <= ticks; ++i) {
            controller.update();
        }
    }

    public boolean inRange(double value, int min, int max) {
        return value >= (double)min && value <= (double)max;
    }

    public boolean atMost(double value, int max) {
        return value <= (double)max;
    }

    public PokemonBuilder createDefaultPokemon(RegistryValue<Species> species) {
        return PokemonBuilder.builder().species(species).level(100).ivs(31, 31, 31, 31, 31, 31).nature(Nature.SERIOUS).evs(0, 0, 0, 0, 0, 0).happiness(255).caughtBall(PokeBallRegistry.POKE_BALL);
    }

    public PokemonBuilder createMagikarp() {
        return this.createDefaultPokemon(PixelmonSpecies.MAGIKARP).moves(AttackRegistry.SPLASH);
    }

    public void autoTurn(BattleController controller) {
        controller.takeFullTurn(() -> {
            for (BattleParticipant participant : controller.participants) {
                if (!(participant instanceof TestParticipant)) continue;
                TestParticipant testParticipant = (TestParticipant)participant;
                testParticipant.attackAuto();
            }
        });
    }
}

