/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.tags;

import java.util.Collection;
import java.util.function.Function;
import net.minecraft.core.Holder;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;

public class TagsHelper {
    public static boolean is(Holder<?> holder, TagEntry ... entries) {
        for (TagEntry entry : entries) {
            if (entry.isTag() && holder.getTagKeys().anyMatch(tagKey -> tagKey.f_203868_().equals((Object)entry.getId()))) {
                return true;
            }
            if (!holder.m_203373_(entry.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean is(Holder<?> holder, Collection<TagEntry> entries) {
        for (TagEntry entry : entries) {
            if (entry.isTag() && holder instanceof Holder.Reference) {
                Holder.Reference reference = (Holder.Reference)holder;
                for (TagKey tagKey : reference.f_205749_) {
                    if (!tagKey.f_203868_().equals((Object)entry.getId())) continue;
                    return true;
                }
            }
            if (!holder.m_203373_(entry.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean allMatch(Collection<Holder<?>> holder, Collection<TagEntry> entries) {
        for (Holder<?> holder1 : holder) {
            if (TagsHelper.is(holder1, entries)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean allMatch(Collection<T> values, Function<T, Holder<T>> conversion, Collection<TagEntry> entries) {
        for (T value : values) {
            if (TagsHelper.is(conversion.apply(value), entries)) continue;
            return false;
        }
        return true;
    }
}

