/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage.breeding;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.data.PixelmonDataSerializers;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBase;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.breeding.DayCareBox;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.packetHandlers.daycare.UpdateDayCareHistoryPacket;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerDayCare {
    private int allowedBoxes = PixelmonConfigProxy.getBreeding().getDefaultDayCareAmount();
    private List<DayCareBox> dayCareBoxes = Lists.newArrayList();
    private List<PokemonBase> history = Lists.newArrayList();
    private BitSet paidFor = new BitSet();
    private PlayerPartyStorage party;
    private UUID parentOne;
    private UUID parentTwo;
    private Pokemon egg;

    public PlayerDayCare(PlayerPartyStorage party) {
        this.party = party;
    }

    public void reset() {
        this.dayCareBoxes = Lists.newArrayList();
        this.history = Lists.newArrayList();
        this.paidFor = new BitSet();
        this.party.setNeedsSaving();
    }

    public boolean hasPaidFor(Pokemon pokemon) {
        return this.paidFor.get(pokemon.getSpecies().getDex());
    }

    public void setPaidFor(Pokemon pokemon) {
        this.setPaidFor(pokemon, true);
    }

    public void setPaidFor(Pokemon pokemon, boolean paidFor) {
        this.paidFor.set(pokemon.getForm().getTypes().get(0).ordinal(), paidFor);
    }

    public void setAllowedBoxes(int allowedBoxes) {
        this.allowedBoxes = allowedBoxes;
        this.party.setHasChanged(true);
    }

    public int getAllowedBoxes() {
        return this.allowedBoxes;
    }

    public Optional<DayCareBox> getOrCreateBox(int boxId) {
        if (!this.hasBox(boxId)) {
            return Optional.empty();
        }
        for (DayCareBox dayCareBox : this.dayCareBoxes) {
            if (dayCareBox.getBoxId() != boxId) continue;
            return Optional.of(dayCareBox);
        }
        DayCareBox dayCareBox = new DayCareBox(this, boxId);
        this.dayCareBoxes.add(dayCareBox);
        return Optional.of(dayCareBox);
    }

    public Optional<DayCareBox> getBox(int boxId) {
        if (!this.hasBox(boxId)) {
            return Optional.empty();
        }
        for (DayCareBox dayCareBox : this.dayCareBoxes) {
            if (dayCareBox.getBoxId() != boxId) continue;
            return Optional.of(dayCareBox);
        }
        return Optional.empty();
    }

    public boolean hasBox(int boxId) {
        return boxId >= 0 && boxId <= this.getAllowedBoxes();
    }

    @Nullable
    public DayCareBox getFirstEmptyBox() {
        for (int i = 0; i < this.allowedBoxes; ++i) {
            Optional<DayCareBox> dayCareBox = this.getOrCreateBox(i);
            if (!dayCareBox.get().isEmpty()) continue;
            return dayCareBox.get();
        }
        return null;
    }

    public PlayerPartyStorage getParty() {
        return this.party;
    }

    public boolean isFull() {
        if (this.dayCareBoxes.size() < this.allowedBoxes) {
            return false;
        }
        for (DayCareBox dayCareBox : this.dayCareBoxes) {
            if (!dayCareBox.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void setBox(DayCareBox box) {
        this.dayCareBoxes.removeIf(dayCareBox -> dayCareBox.getBoxId() == box.getBoxId());
        this.dayCareBoxes.add(box);
    }

    public List<PokemonBase> getHistory() {
        return this.history;
    }

    public void addHistory(Pokemon pokemon) {
        this.addHistory(pokemon, false);
    }

    public void addHistory(Pokemon pokemon, boolean bothParentsDitto) {
        PokemonBase pokemonBase = new PokemonBase(pokemon);
        if (!bothParentsDitto) {
            pokemonBase.setEggCycles(-1);
        }
        this.history.add(pokemonBase);
        if (this.history.size() > 36) {
            this.history.remove(0);
        }
        this.party.setNeedsSaving();
        NetworkHelper.sendPacket(this.party.getPlayer(), new UpdateDayCareHistoryPacket(this.history));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setHistory(List<PokemonBase> history) {
        this.history = history;
    }

    public void updateHistory(Pokemon pokemon) {
        PokemonBase pokemonBase = new PokemonBase(pokemon);
        for (PokemonBase bredPokemon : this.history) {
            if (bredPokemon.getSpecies() != pokemonBase.getSpecies() || bredPokemon.getForm() != pokemonBase.getForm() || bredPokemon.getPalette() != pokemonBase.getPalette() || bredPokemon.getBall() != pokemonBase.getBall() || bredPokemon.getGender() != pokemonBase.getGender() || bredPokemon.getEggCycles() == -1) continue;
            this.history.set(this.history.indexOf(bredPokemon), pokemonBase);
            this.party.setNeedsSaving();
            NetworkHelper.sendPacket(this.party.getPlayer(), new UpdateDayCareHistoryPacket(this.history));
        }
    }

    public UUID getParentOne() {
        return this.parentOne;
    }

    public UUID getParentTwo() {
        return this.parentTwo;
    }

    public Pokemon getEgg() {
        return this.egg;
    }

    public void setParentOne(UUID parentOne) {
        this.parentOne = parentOne;
    }

    public void setParentTwo(UUID parentTwo) {
        this.parentTwo = parentTwo;
    }

    public void setEgg(Pokemon egg) {
        this.egg = egg;
    }

    public void tick() {
        for (DayCareBox dayCareBox : this.dayCareBoxes) {
            if (dayCareBox.isEmpty() || !dayCareBox.hasBreedingBegun()) continue;
            dayCareBox.tick();
        }
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.dayCareBoxes.size());
        for (DayCareBox dayCareBox : this.dayCareBoxes) {
            dayCareBox.encode(buffer);
        }
        buffer.writeInt(this.history.size());
        for (PokemonBase pokemonBase : this.history) {
            PixelmonDataSerializers.POKEMON_BASE.m_6856_(buffer, (Object)pokemonBase);
        }
        buffer.writeInt(this.allowedBoxes);
    }

    public static PlayerDayCare decode(PlayerPartyStorage storage, FriendlyByteBuf buffer) {
        PlayerDayCare dayCare = new PlayerDayCare(storage);
        int boxes = buffer.readInt();
        for (int i = 0; i < boxes; ++i) {
            dayCare.dayCareBoxes.add(DayCareBox.decode(dayCare, buffer));
        }
        int history = buffer.readInt();
        for (int i = 0; i < history; ++i) {
            dayCare.history.add((PokemonBase)PixelmonDataSerializers.POKEMON_BASE.m_6709_(buffer));
        }
        dayCare.allowedBoxes = buffer.readInt();
        return dayCare;
    }

    public void writeToNBT(CompoundTag nbt) {
        ListTag boxes = new ListTag();
        for (DayCareBox dayCareBox : this.dayCareBoxes) {
            CompoundTag boxNbt = new CompoundTag();
            dayCareBox.writeToNBT(boxNbt);
            boxes.add((Object)boxNbt);
        }
        ListTag history = new ListTag();
        for (PokemonBase pokemonBase : this.history) {
            CompoundTag historyNbt = new CompoundTag();
            pokemonBase.writeToNBT(historyNbt);
            history.add((Object)historyNbt);
        }
        nbt.m_128405_("DayCareBoxCount", this.allowedBoxes);
        nbt.m_128365_("DayCareHistory", (Tag)history);
        nbt.m_128365_("DayCareBoxes", (Tag)boxes);
        ListTag listTag = new ListTag();
        for (Element value : Element.values()) {
            if (!this.paidFor.get(value.ordinal())) continue;
            listTag.add((Object)IntTag.m_128679_((int)value.ordinal()));
        }
        nbt.m_128365_("DayCarePaidFor", (Tag)listTag);
    }

    public static PlayerDayCare readFromNBT(PlayerPartyStorage party, CompoundTag nbt) {
        CompoundTag CompoundTag2;
        PlayerDayCare dayCare = new PlayerDayCare(party);
        if (nbt.m_128441_("DayCareHistory")) {
            ListTag history = nbt.m_128437_("DayCareHistory", 10);
            for (Tag tag : history) {
                CompoundTag2 = (CompoundTag)tag;
                dayCare.history.add(PokemonBase.fromNBT(CompoundTag2));
            }
        }
        if (nbt.m_128441_("DayCareBoxes")) {
            ListTag boxes = nbt.m_128437_("DayCareBoxes", 10);
            for (Tag tag : boxes) {
                CompoundTag2 = (CompoundTag)tag;
                dayCare.dayCareBoxes.add(DayCareBox.readFromNBT(dayCare, CompoundTag2));
            }
        }
        if (nbt.m_128441_("DayCareBoxCount")) {
            dayCare.allowedBoxes = nbt.m_128451_("DayCareBoxCount");
        }
        if (nbt.m_128441_("DayCarePaidFor")) {
            ListTag paidFor = nbt.m_128437_("DayCarePaidFor", 3);
            for (Tag inbt : paidFor) {
                dayCare.paidFor.set(((IntTag)inbt).m_7047_(), true);
            }
        }
        return dayCare;
    }
}

