/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage.breeding;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.daycare.DayCareCondition;
import com.pixelmonmod.pixelmon.api.daycare.DayCareConditionRegistry;
import com.pixelmonmod.pixelmon.api.daycare.DayCareDuration;
import com.pixelmonmod.pixelmon.api.daycare.DayCareRequirement;
import com.pixelmonmod.pixelmon.api.daycare.event.DayCareEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.api.storage.breeding.PlayerDayCare;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.eventbus.api.Event;

public class DayCareBox {
    private PlayerDayCare dayCare;
    private int boxId;
    private Pokemon parentOne;
    private Pokemon parentTwo;
    private List<DayCareCondition> conditions = Lists.newArrayList();
    private Pokemon egg;
    private long startTime = -1L;
    private long duration = -1L;
    private int hourglassesUsed = 0;
    private boolean empty;
    private boolean ovalCharmActive = false;
    private boolean readyToBreed = false;
    private Component errorMessage;
    private List<Component> allErrorMessages = null;
    private boolean canConsume = false;

    public DayCareBox(PlayerDayCare dayCare, int boxId) {
        this.dayCare = dayCare;
        this.boxId = boxId;
        this.empty = true;
        this.ovalCharmActive = false;
    }

    public int getBoxId() {
        return this.boxId;
    }

    public void setDayCare(PlayerDayCare dayCare) {
        this.dayCare = dayCare;
    }

    public void completeCondition(DayCareCondition condition) {
        this.conditions.remove(condition);
        if (this.conditions.isEmpty()) {
            this.readyToBreed = true;
        }
    }

    public List<Component> calculateAllErrors() {
        ArrayList remaining = Lists.newArrayList();
        for (DayCareCondition condition : this.conditions) {
            for (DayCareRequirement remainingRequirement : condition.getRemainingRequirements()) {
                remaining.add(remainingRequirement.getError());
            }
        }
        return remaining;
    }

    public void beginBreeding() {
        DayCareEvent.PreTimerBegin preEvent = new DayCareEvent.PreTimerBegin(this.dayCare.getParty().getPlayer(), this.dayCare.getParty(), this, this.duration);
        if (Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            return;
        }
        this.startTime = System.currentTimeMillis();
        this.duration = preEvent.getDuration();
        if (StorageProxy.getPartyNow(this.dayCare.getParty().getPlayer()).getOvalCharm().isActive() && !this.ovalCharmActive) {
            this.duration = (long)((float)this.duration * PixelmonConfigProxy.getBreeding().getOvalCharmMultiplier());
            this.ovalCharmActive = true;
        }
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.PostTimerBegin(this.dayCare.getParty().getPlayer(), this.dayCare.getParty(), this, this.duration));
    }

    public boolean hasBreedingBegun() {
        return this.startTime != -1L;
    }

    public void tick() {
        if (this.getPercentComplete() < 100.0) {
            return;
        }
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.TimerComplete(this.dayCare.getParty().getPlayer(), this.dayCare.getParty(), this, this.duration));
        this.dayCare.getParty().setNeedsSaving();
    }

    @Nullable
    public Pokemon getParent(int id) {
        if (id < 1 || id > 2) {
            return null;
        }
        return id == 1 ? this.getParentOne() : this.getParentTwo();
    }

    @Nullable
    public Pokemon getParentOne() {
        return this.parentOne;
    }

    @Nullable
    public Pokemon getParentTwo() {
        return this.parentTwo;
    }

    @Nullable
    public Pokemon getEgg() {
        return this.egg;
    }

    public void setEgg(Pokemon egg) {
        this.egg = egg;
    }

    public void addDayCare(Pokemon parentOne, Pokemon parentTwo, Pokemon egg) {
        if (!egg.isEgg()) {
            egg.makeEgg();
        }
        this.parentOne = parentOne;
        this.parentTwo = parentTwo;
        this.egg = egg;
        this.empty = false;
        this.conditions = Lists.newArrayList();
        long calculatedDuration = 0L;
        ArrayList durations = Lists.newArrayList();
        for (DayCareCondition allCondition : DayCareConditionRegistry.getAllConditions()) {
            if (!allCondition.isConditionFor(this.parentOne, this.parentTwo, this.egg)) continue;
            this.conditions.add(allCondition.clone());
            durations.addAll(allCondition.getDurations());
        }
        durations.sort(Comparator.comparing(DayCareDuration::getPriority));
        for (DayCareDuration duration : durations) {
            calculatedDuration = duration.getMillisecondValue(this.dayCare.getParty().getPlayer(), this, calculatedDuration);
        }
        if (calculatedDuration < 0L) {
            calculatedDuration = 0L;
        }
        DayCareEvent.PreDurationCalculate preEvent = new DayCareEvent.PreDurationCalculate(this.dayCare.getParty().getPlayer(), this.dayCare.getParty(), this, calculatedDuration);
        Pixelmon.EVENT_BUS.post((Event)preEvent);
        this.duration = preEvent.getDuration();
        if (StorageProxy.getPartyNow(this.dayCare.getParty().getPlayer()).getOvalCharm().isActive() && !this.ovalCharmActive) {
            this.duration = (long)((float)this.duration * PixelmonConfigProxy.getBreeding().getOvalCharmMultiplier());
            this.ovalCharmActive = true;
        }
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.PostDurationCalculate(this.dayCare.getParty().getPlayer(), this.dayCare.getParty(), this, this.duration));
        this.dayCare.getParty().setNeedsSaving();
    }

    public boolean canBreedingBegin() {
        return this.readyToBreed && !this.isEmpty() && this.conditions.isEmpty();
    }

    public double getPercentComplete() {
        if (!this.hasBreedingBegun()) {
            return 0.0;
        }
        long duration = System.currentTimeMillis() - this.startTime;
        if (duration >= this.duration) {
            return 100.0;
        }
        return ((double)duration / ((double)this.duration + 0.0) + (double)this.hourglassesUsed * 0.25) * 100.0;
    }

    public long getTotalDuration() {
        return this.duration;
    }

    @Nullable
    public DayCareCondition getNextCondition() {
        if (this.canBreedingBegin() || this.conditions.isEmpty()) {
            this.readyToBreed = true;
            return null;
        }
        return this.conditions.get(0);
    }

    public List<DayCareCondition> getConditions() {
        return this.conditions;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component getErrorMessage() {
        return this.errorMessage;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Component> getAllErrorMessages() {
        return this.allErrorMessages;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setAllErrorMessages(List<Component> allErrorMessages) {
        this.allErrorMessages = allErrorMessages;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean canConsume() {
        return this.canConsume;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setStatus(Component errorMessage, boolean canConsume) {
        this.errorMessage = errorMessage;
        this.canConsume = canConsume;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setReadyToBreed(boolean readyToBreed) {
        this.readyToBreed = readyToBreed;
    }

    public void setHourglassesUsed(int hourglassesUsed) {
        this.hourglassesUsed = hourglassesUsed;
        this.dayCare.getParty().setNeedsSaving();
    }

    public int getHourglassesUsed() {
        return this.hourglassesUsed;
    }

    public boolean getOvalCharmActive() {
        return this.ovalCharmActive;
    }

    public void complete() {
        this.conditions.clear();
        this.readyToBreed = true;
        this.startTime = System.currentTimeMillis() - 1L;
        this.duration = 1L;
        this.tick();
    }

    public void returnToStorage() {
        DayCareEvent.PreCollect preEvent = new DayCareEvent.PreCollect(this.dayCare.getParty().getPlayer(), this.dayCare.getParty(), this.parentOne, this.parentTwo, this.egg);
        if (Pixelmon.EVENT_BUS.post((Event)preEvent)) {
            return;
        }
        if (preEvent.getParentOne() != null) {
            this.dayCare.getParty().add(preEvent.getParentOne());
        }
        if (preEvent.getParentTwo() != null) {
            this.dayCare.getParty().add(preEvent.getParentTwo());
        }
        if (preEvent.getChildGiven() != null) {
            this.dayCare.getParty().add(preEvent.getChildGiven());
            if (preEvent.shouldAddToHistory()) {
                this.dayCare.addHistory(preEvent.getChildGiven(), preEvent.getParentOne().getSpecies().is(PixelmonSpecies.DITTO) && preEvent.getParentTwo().getSpecies().is(PixelmonSpecies.DITTO));
            }
        }
        Pixelmon.EVENT_BUS.post((Event)new DayCareEvent.PostCollect(this.dayCare.getParty().getPlayer(), this.dayCare.getParty(), preEvent.getParentOne(), preEvent.getParentTwo(), preEvent.getChildGiven(), preEvent.shouldAddToHistory()));
        this.empty();
    }

    public void empty() {
        this.parentOne = null;
        this.parentTwo = null;
        this.egg = null;
        this.startTime = -1L;
        this.duration = -1L;
        this.hourglassesUsed = 0;
        this.conditions = null;
        this.empty = true;
        this.readyToBreed = false;
        this.ovalCharmActive = false;
        this.dayCare.getParty().setNeedsSaving();
    }

    public void writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("DayCareBoxId", this.boxId);
        nbt.m_128379_("DayCareBoxEmpty", this.isEmpty());
        if (!this.isEmpty()) {
            if (this.parentOne != null) {
                CompoundTag parentOne = new CompoundTag();
                this.parentOne.writeToNBT(parentOne);
                nbt.m_128365_("DayCareParentOne", (Tag)parentOne);
            }
            if (this.parentTwo != null) {
                CompoundTag parentTwo = new CompoundTag();
                this.parentTwo.writeToNBT(parentTwo);
                nbt.m_128365_("DayCareParentTwo", (Tag)parentTwo);
            }
            if (this.egg != null) {
                CompoundTag egg = new CompoundTag();
                this.egg.writeToNBT(egg);
                nbt.m_128365_("DayCareEgg", (Tag)egg);
            }
            ListTag conditions = new ListTag();
            for (DayCareCondition condition : this.conditions) {
                CompoundTag tag = new CompoundTag();
                condition.write(tag);
                conditions.add((Object)tag);
            }
            nbt.m_128365_("DayCareConditions", (Tag)conditions);
            nbt.m_128356_("DayCareStartTime", this.startTime);
            nbt.m_128356_("DayCareDuration", this.duration);
            nbt.m_128405_("DayCareHourGlassesUsed", this.hourglassesUsed);
            nbt.m_128379_("DayCareReadyToBreed", this.readyToBreed);
            nbt.m_128379_("DayCareBoxOvalCharmActive", this.ovalCharmActive);
        }
    }

    public static DayCareBox readFromNBT(PlayerDayCare dayCare, CompoundTag nbt) {
        int boxId = nbt.m_128451_("DayCareBoxId");
        boolean empty = nbt.m_128471_("DayCareBoxEmpty");
        DayCareBox box = new DayCareBox(dayCare, boxId);
        box.empty = empty;
        if (empty) {
            return box;
        }
        if (nbt.m_128441_("DayCareParentOne")) {
            box.parentOne = PokemonFactory.create(nbt.m_128469_("DayCareParentOne"));
        }
        if (nbt.m_128441_("DayCareParentTwo")) {
            box.parentTwo = PokemonFactory.create(nbt.m_128469_("DayCareParentTwo"));
        }
        if (nbt.m_128441_("DayCareEgg")) {
            box.egg = PokemonFactory.create(nbt.m_128469_("DayCareEgg"));
        }
        box.startTime = nbt.m_128454_("DayCareStartTime");
        box.duration = nbt.m_128454_("DayCareDuration");
        box.hourglassesUsed = nbt.m_128451_("DayCareHourGlassesUsed");
        box.readyToBreed = nbt.m_128471_("DayCareReadyToBreed");
        box.ovalCharmActive = nbt.m_128471_("DayCareBoxOvalCharmActive");
        for (Tag tag : nbt.m_128437_("DayCareConditions", 10)) {
            CompoundTag conditionNBT = (CompoundTag)tag;
            DayCareCondition condition = DayCareConditionRegistry.getConditionSupplier().get();
            condition.read(conditionNBT);
            if (condition.isComplete()) continue;
            box.conditions.add(condition);
        }
        return box;
    }

    public void encode(FriendlyByteBuf buffer) {
        buffer.writeInt(this.boxId);
        buffer.writeBoolean(this.isEmpty());
        if (!this.isEmpty()) {
            buffer.writeBoolean(this.parentOne != null);
            if (this.parentOne != null) {
                this.parentOne.writeToByteBuffer(buffer, new EnumUpdateType[0]);
            }
            buffer.writeBoolean(this.parentTwo != null);
            if (this.parentTwo != null) {
                this.parentTwo.writeToByteBuffer(buffer, new EnumUpdateType[0]);
            }
            buffer.writeBoolean(this.egg != null);
            if (this.egg != null) {
                this.egg.writeToByteBuffer(buffer, new EnumUpdateType[0]);
            }
            buffer.writeLong(this.startTime);
            buffer.writeLong(this.duration);
            buffer.writeInt(this.hourglassesUsed);
            buffer.writeBoolean(this.readyToBreed);
            buffer.writeBoolean(this.ovalCharmActive);
        }
    }

    public static DayCareBox decode(PlayerDayCare dayCare, FriendlyByteBuf buffer) {
        DayCareBox box = new DayCareBox(dayCare, buffer.readInt());
        if (buffer.readBoolean()) {
            return box;
        }
        box.empty = false;
        if (buffer.readBoolean()) {
            box.parentOne = PokemonFactory.create(buffer);
        }
        if (buffer.readBoolean()) {
            box.parentTwo = PokemonFactory.create(buffer);
        }
        if (buffer.readBoolean()) {
            box.egg = PokemonFactory.create(buffer);
        }
        box.startTime = buffer.readLong();
        box.duration = buffer.readLong();
        box.hourglassesUsed = buffer.readInt();
        box.readyToBreed = buffer.readBoolean();
        box.ovalCharmActive = buffer.readBoolean();
        return box;
    }
}

